/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.session.strategy;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.utils.UrlUtil;

public class DefaultForwardInvalidSessionStrategy
implements InvalidSessionStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultForwardInvalidSessionStrategy.class);

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String queryString = request.getQueryString();
        if (StringUtils.hasText((String)queryString)) {
            queryString = "?" + queryString;
        }
        String forwardUrl = UrlUtil.getUrlPathHelper().getPathWithinApplication(request) + Optional.ofNullable(queryString).orElse("");
        if (log.isDebugEnabled()) {
            log.debug("Starting new session and forward");
        }
        request.getSession(true);
        request.getRequestDispatcher(forwardUrl).forward((ServletRequest)request, (ServletResponse)response);
    }
}

