/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.NonNull;
import org.springframework.security.web.util.UrlUtils;

public final class RequestUtil {
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private RequestUtil() {
    }

    @NonNull
    public static String getRequestUri(@NonNull String url, @NonNull HttpServletRequest request) {
        String servletContextPath;
        int endIndex;
        if (UrlUtils.isAbsoluteUrl((String)url)) {
            url = url.replaceFirst("\\A[a-z0-9.+-]+://", "");
            url = url.substring(url.indexOf("/"));
        }
        if ((endIndex = url.indexOf("?")) > 0) {
            url = url.substring(0, endIndex);
        }
        if ((endIndex = url.indexOf("#")) > 0) {
            url = url.substring(0, endIndex);
        }
        if (url.startsWith(servletContextPath = request.getContextPath())) {
            url = url.substring(servletContextPath.length());
        }
        return url;
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        return RequestUtil.readNBytes(Integer.MAX_VALUE, inputStream);
    }

    private static byte[] readNBytes(int len, InputStream inputStream) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = inputStream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }
}

