/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import top.dcenter.ums.security.common.api.jackson2.SimpleModuleHolder;
import top.dcenter.ums.security.core.advice.SecurityControllerAdviceHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.api.tenant.handler.TenantContextHolder;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.controller.ClientSecurityController;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationFailureHandler;
import top.dcenter.ums.security.core.auth.handler.ClientAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.auth.handler.DefaultLogoutSuccessHandler;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;
import top.dcenter.ums.security.core.redis.jackson2.AuthJackson2ModuleHolder;
import top.dcenter.ums.security.core.util.MvcUtil;

@Configuration(proxyBeanMethods=false)
@Order(value=98)
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class})
@SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
public class SecurityAutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(SecurityAutoConfiguration.class);
    private final ClientProperties clientProperties;
    @Autowired
    private UmsUserDetailsService umsUserDetailsService;
    @Autowired(required=false)
    private TenantContextHolder tenantContextHolder;

    public SecurityAutoConfiguration(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return PasswordEncoderFactories.createDelegatingPasswordEncoder();
    }

    @Bean
    public SimpleModuleHolder authJackson2ModuleHolder() {
        return new AuthJackson2ModuleHolder();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler"})
    public BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler() {
        return new ClientAuthenticationSuccessHandler(this.clientProperties, null);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler"})
    public BaseAuthenticationFailureHandler baseAuthenticationFailureHandler() {
        return new ClientAuthenticationFailureHandler(this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.advice.SecurityControllerAdviceHandler"})
    public SecurityControllerAdviceHandler securityControllerExceptionHandler() {
        return new SecurityControllerAdviceHandler();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider"})
    public UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider(PasswordEncoder passwordEncoder) {
        return new UsernamePasswordAuthenticationProvider(passwordEncoder, this.umsUserDetailsService, this.tenantContextHolder);
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.web.authentication.logout.LogoutSuccessHandler"})
    public LogoutSuccessHandler logoutSuccessHandler() {
        return new DefaultLogoutSuccessHandler(this.clientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.controller.BaseSecurityController"})
    @ConditionalOnProperty(prefix="ums.client", name={"open-authentication-redirect"}, havingValue="true")
    public ClientSecurityController clientSecurityController() {
        return new ClientSecurityController(this.clientProperties);
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        if (this.clientProperties.getSuppressReflectWarning().booleanValue()) {
            SecurityAutoConfiguration.disableAccessWarnings();
        }
        Class<MvcUtil> mvcUtilClass = MvcUtil.class;
        Class.forName(mvcUtilClass.getName());
        for (Field field : declaredFields = mvcUtilClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (!Objects.equals(field.getName(), "topDomain")) continue;
            field.set(null, this.clientProperties.getTopDomain());
        }
    }

    private static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception ignored) {
            log.info("\u5ffd\u7565\u975e\u6cd5\u53cd\u5c04\u8b66\u544a\u914d\u7f6e\u5931\u6548!");
        }
    }
}

