/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public class DefaultLogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultLogoutSuccessHandler.class);
    protected final RedirectStrategy redirectStrategy;
    protected final String logoutSuccessUrl;
    protected final LoginProcessType loginProcessType;
    @Autowired(required=false)
    protected UserCache userCache;

    public DefaultLogoutSuccessHandler(ClientProperties clientProperties) {
        this.loginProcessType = clientProperties.getLoginProcessType();
        this.logoutSuccessUrl = clientProperties.getLogoutSuccessUrl();
        this.redirectStrategy = new DefaultRedirectStrategy();
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        HttpSession session = request.getSession(true);
        log.info("\u767b\u51fa\u6210\u529f: user={}, ip={}, ua={}, sid={}, sck={}", new Object[]{authentication != null ? authentication.getPrincipal() : "", IpUtil.getRealIp((HttpServletRequest)request), request.getHeader("User-Agent"), session.getId(), session.getAttribute("SESSION_ENHANCE_CHECK_KEY")});
        session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        if (this.userCache != null && authentication != null) {
            this.userCache.removeUserFromCache(authentication.getName());
        }
        AuthenticationUtil.redirectProcessingLogoutByLoginProcessType(request, response, this.logoutSuccessUrl, this.loginProcessType, this.redirectStrategy, ErrorCodeEnum.LOGOUT_SUCCESS);
    }
}

