/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.mobile;

import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.mobile.SmsCodeLoginAuthenticationToken;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;

public class SmsCodeLoginAuthenticationProvider
implements AuthenticationProvider {
    private final UmsUserDetailsService userDetailsService;
    private final GenerateClaimsSetService generateClaimsSetService;

    public SmsCodeLoginAuthenticationProvider(@NonNull UmsUserDetailsService userDetailsService, @Nullable GenerateClaimsSetService generateClaimsSetService) {
        this.userDetailsService = userDetailsService;
        this.generateClaimsSetService = generateClaimsSetService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails user;
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        SmsCodeLoginAuthenticationToken authenticationToken = (SmsCodeLoginAuthenticationToken)authentication;
        if (authentication.isAuthenticated()) {
            return authentication;
        }
        try {
            user = this.userDetailsService.loadUserByUsername((String)authenticationToken.getPrincipal());
        }
        catch (UsernameNotFoundException e) {
            user = null;
        }
        if (user == null) {
            user = this.userDetailsService.registerUser((String)authenticationToken.getPrincipal());
        }
        SmsCodeLoginAuthenticationToken authenticationResult = new SmsCodeLoginAuthenticationToken(user, user.getAuthorities());
        authenticationResult.setDetails(authenticationToken.getDetails());
        return JwtContext.createJwtAndToJwtAuthenticationToken((Authentication)authenticationResult, (GenerateClaimsSetService)this.generateClaimsSetService);
    }

    public boolean supports(Class<?> authentication) {
        return SmsCodeLoginAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

