/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.dcenter.ums.security.common.executor.DefaultThreadFactory;
import top.dcenter.ums.security.common.executor.MdcScheduledThreadPoolExecutor;
import top.dcenter.ums.security.core.tasks.config.ScheduledPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.tasks.properties.JobTaskScheduledExecutorProperties;

@Configuration
@AutoConfigureAfter(value={ScheduledPropertiesAutoConfiguration.class})
public class ScheduledExecutorAutoConfiguration
implements DisposableBean {
    private final JobTaskScheduledExecutorProperties jobTaskScheduledExecutorProperties;
    private ScheduledExecutorService jobTaskScheduledExecutor;

    public ScheduledExecutorAutoConfiguration(JobTaskScheduledExecutorProperties jobTaskScheduledExecutorProperties) {
        this.jobTaskScheduledExecutorProperties = jobTaskScheduledExecutorProperties;
    }

    @Bean
    public ScheduledExecutorService jobTaskScheduledExecutor() {
        MdcScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new MdcScheduledThreadPoolExecutor(this.jobTaskScheduledExecutorProperties.getCorePoolSize().intValue(), this.getThreadFactory(this.jobTaskScheduledExecutorProperties.getPoolName()), this.jobTaskScheduledExecutorProperties.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        scheduledThreadPoolExecutor.setKeepAliveTime(this.jobTaskScheduledExecutorProperties.getKeepAliveTime().intValue(), this.jobTaskScheduledExecutorProperties.getTimeUnit());
        this.jobTaskScheduledExecutor = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void destroy() throws Exception {
        if (this.jobTaskScheduledExecutor != null) {
            this.jobTaskScheduledExecutor.shutdown();
            this.jobTaskScheduledExecutor.awaitTermination(this.jobTaskScheduledExecutorProperties.getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.jobTaskScheduledExecutor.isTerminated()) {
                this.jobTaskScheduledExecutor.shutdownNow();
            }
        }
    }
}

