/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;

public final class MvcUtil {
    public static final String TOP_DOMAIN_PARAM_NAME = "topDomain";
    public static final String IP6_SEPARATOR = ":";
    public static final String LOCALHOST = "localhost";
    private static String topDomain = "";

    private MvcUtil() {
    }

    public static String getTopDomain() {
        if (StringUtils.hasText((String)topDomain)) {
            return topDomain;
        }
        throw new RuntimeException("topDomain \u672a\u521d\u59cb\u5316, \u53ef\u901a\u8fc7\u5c5e\u6027 ums.client.topDomain \u8bbe\u7f6e\u6b64\u503c.");
    }

    public static String getTopDomain(HttpServletRequest request) {
        String serverName = request.getServerName();
        if (serverName.contains(IP6_SEPARATOR)) {
            return serverName;
        }
        if (serverName.equalsIgnoreCase(LOCALHOST)) {
            return serverName;
        }
        int lastIndexOf = serverName.lastIndexOf(".");
        if (Pattern.matches("\\d", serverName.substring(lastIndexOf + 1))) {
            return serverName;
        }
        Pattern pattern = Pattern.compile("^([^\\.]+\\.)+((([^\\.]+\\.)((com\\.))([^\\.]{1,4}$))|((.*(?<!com)\\.)([^\\.]+$)))");
        Matcher matcher = pattern.matcher(serverName);
        if (matcher.find()) {
            return matcher.group(2);
        }
        return serverName;
    }

    public static boolean isSelfTopDomain(String redirectUrl) {
        Pattern pattern = Pattern.compile("^([a-zA-z]+://)");
        Matcher matcher = pattern.matcher(redirectUrl);
        if (matcher.find()) {
            String uri = matcher.replaceFirst("");
            int indexOf = uri.indexOf("/");
            if (indexOf != -1) {
                uri = uri.substring(0, indexOf);
            }
            return uri.contains(topDomain);
        }
        return true;
    }
}

