/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.session.strategy;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public final class DefaultRedirectInvalidSessionStrategy
implements InvalidSessionStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultRedirectInvalidSessionStrategy.class);
    private final String destinationUrl;
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private boolean createNewSession = true;
    private final AntPathMatcher matcher;
    private final RequestCache requestCache;

    public DefaultRedirectInvalidSessionStrategy(String invalidSessionUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)invalidSessionUrl), (String)"url must start with '/' or with 'http(s)'");
        this.destinationUrl = invalidSessionUrl;
        this.matcher = new AntPathMatcher();
        this.requestCache = new HttpSessionRequestCache();
    }

    public void onInvalidSessionDetected(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUrl = AuthenticationUtil.determineInvalidSessionRedirectUrl(request, response, this.destinationUrl, this.matcher, this.requestCache);
        if (log.isDebugEnabled()) {
            log.debug("Starting new session and redirecting to '{}'", (Object)redirectUrl);
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    public void setCreateNewSession(boolean createNewSession) {
        this.createNewSession = createNewSession;
    }
}

