/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.common.propertis.RememberMeProperties;
import top.dcenter.ums.security.core.api.rememberme.repository.BasedRememberMeTokenRepositoryFactory;
import top.dcenter.ums.security.core.auth.config.PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.rememberme.repository.JdbcTokenRepositoryFactory;

@Configuration
@ConditionalOnProperty(prefix="ums.client.remember-me", name={"enable"}, havingValue="true")
@AutoConfigureAfter(value={PropertiesAutoConfiguration.class, SecurityAutoConfiguration.class})
public class SecurityRememberMeAutoConfiguration {
    private final DataSource dataSource;

    public SecurityRememberMeAutoConfiguration(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    public RememberMeProperties rememberMeProperties(ClientProperties clientProperties) {
        return clientProperties.getRememberMe();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.api.rememberme.repository.BasedRememberMeTokenRepositoryFactory", "org.springframework.security.web.authentication.RememberMeServices"})
    public BasedRememberMeTokenRepositoryFactory userTokenRepositoryFactory() {
        return new JdbcTokenRepositoryFactory(this.dataSource);
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.security.web.authentication.RememberMeServices"})
    public PersistentTokenRepository persistentTokenRepository(BasedRememberMeTokenRepositoryFactory userTokenRepositoryFactory) {
        return userTokenRepositoryFactory.getPersistentTokenRepository();
    }
}

