/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.properties;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.validation.annotation.Validated;
import top.dcenter.ums.security.common.enums.CsrfTokenRepositoryType;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.propertis.RememberMeProperties;

@Validated
@ConfigurationProperties(value="ums.client")
public class ClientProperties {
    private final SessionProperties session = new SessionProperties();
    @NestedConfigurationProperty
    private final RememberMeProperties rememberMe = new RememberMeProperties();
    private final CsrfProperties csrf = new CsrfProperties();
    private final AnonymousProperties anonymous = new AnonymousProperties();
    private final CorsProperties cors = new CorsProperties();
    @NotNull(message="ums.client.topDomain \u503c\u5fc5\u987b\u8bbe\u7f6e")
    private @NotNull(message="ums.client.topDomain \u503c\u5fc5\u987b\u8bbe\u7f6e") String topDomain;
    private String usernameParameter = "username";
    private String passwordParameter = "password";
    private String loginPage = "/login";
    private String loginProcessingUrl = "/authentication/form";
    private String failureUrl = this.loginPage;
    private String successUrl = "/";
    private String targetUrlParameter = "redirectTargetUrl";
    private Boolean useReferer = true;
    private Boolean alwaysUseDefaultTargetUrl = Boolean.FALSE;
    private String logoutUrl = "/logout";
    private String logoutSuccessUrl = "/login";
    @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
    private String[] ignoringUrls;
    private Set<String> permitUrls = new HashSet<String>();
    private Boolean openAuthenticationRedirect = false;
    private String loginUnAuthenticationRoutingUrl = "/authentication/require";
    private List<String> authRedirectSuffixCondition = new ArrayList<String>();
    private LoginProcessType loginProcessType = LoginProcessType.JSON;
    private Boolean sameOrigin = Boolean.FALSE;
    private Boolean suppressReflectWarning = false;

    public String getQueryRememberMeTableExistSql(String databaseName) {
        return "SELECT COUNT(1) FROM information_schema.tables WHERE table_schema='" + databaseName + "' AND table_name = 'persistent_logins'";
    }

    public SessionProperties getSession() {
        return this.session;
    }

    public RememberMeProperties getRememberMe() {
        return this.rememberMe;
    }

    public CsrfProperties getCsrf() {
        return this.csrf;
    }

    public AnonymousProperties getAnonymous() {
        return this.anonymous;
    }

    public CorsProperties getCors() {
        return this.cors;
    }

    public String getTopDomain() {
        return this.topDomain;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public String getLoginPage() {
        return this.loginPage;
    }

    public String getLoginProcessingUrl() {
        return this.loginProcessingUrl;
    }

    public String getFailureUrl() {
        return this.failureUrl;
    }

    public String getSuccessUrl() {
        return this.successUrl;
    }

    public String getTargetUrlParameter() {
        return this.targetUrlParameter;
    }

    public Boolean getUseReferer() {
        return this.useReferer;
    }

    public Boolean getAlwaysUseDefaultTargetUrl() {
        return this.alwaysUseDefaultTargetUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public String[] getIgnoringUrls() {
        return this.ignoringUrls;
    }

    public Set<String> getPermitUrls() {
        return this.permitUrls;
    }

    public Boolean getOpenAuthenticationRedirect() {
        return this.openAuthenticationRedirect;
    }

    public String getLoginUnAuthenticationRoutingUrl() {
        return this.loginUnAuthenticationRoutingUrl;
    }

    public List<String> getAuthRedirectSuffixCondition() {
        return this.authRedirectSuffixCondition;
    }

    public LoginProcessType getLoginProcessType() {
        return this.loginProcessType;
    }

    public Boolean getSameOrigin() {
        return this.sameOrigin;
    }

    public Boolean getSuppressReflectWarning() {
        return this.suppressReflectWarning;
    }

    public void setTopDomain(String topDomain) {
        this.topDomain = topDomain;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setLoginPage(String loginPage) {
        this.loginPage = loginPage;
    }

    public void setLoginProcessingUrl(String loginProcessingUrl) {
        this.loginProcessingUrl = loginProcessingUrl;
    }

    public void setFailureUrl(String failureUrl) {
        this.failureUrl = failureUrl;
    }

    public void setSuccessUrl(String successUrl) {
        this.successUrl = successUrl;
    }

    public void setTargetUrlParameter(String targetUrlParameter) {
        this.targetUrlParameter = targetUrlParameter;
    }

    public void setUseReferer(Boolean useReferer) {
        this.useReferer = useReferer;
    }

    public void setAlwaysUseDefaultTargetUrl(Boolean alwaysUseDefaultTargetUrl) {
        this.alwaysUseDefaultTargetUrl = alwaysUseDefaultTargetUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public void setIgnoringUrls(String[] ignoringUrls) {
        this.ignoringUrls = ignoringUrls;
    }

    public void setPermitUrls(Set<String> permitUrls) {
        this.permitUrls = permitUrls;
    }

    public void setOpenAuthenticationRedirect(Boolean openAuthenticationRedirect) {
        this.openAuthenticationRedirect = openAuthenticationRedirect;
    }

    public void setLoginUnAuthenticationRoutingUrl(String loginUnAuthenticationRoutingUrl) {
        this.loginUnAuthenticationRoutingUrl = loginUnAuthenticationRoutingUrl;
    }

    public void setAuthRedirectSuffixCondition(List<String> authRedirectSuffixCondition) {
        this.authRedirectSuffixCondition = authRedirectSuffixCondition;
    }

    public void setLoginProcessType(LoginProcessType loginProcessType) {
        this.loginProcessType = loginProcessType;
    }

    public void setSameOrigin(Boolean sameOrigin) {
        this.sameOrigin = sameOrigin;
    }

    public void setSuppressReflectWarning(Boolean suppressReflectWarning) {
        this.suppressReflectWarning = suppressReflectWarning;
    }

    public static class CorsProperties {
        private Boolean enable = false;
        private List<String> accessControlAllowOrigin;
        private Boolean accessControlAllowCredentials = true;
        private List<String> accessControlExposeHeaders;
        private Duration accessControlMaxAge;
        private List<String> accessControlAllowMethods;
        private List<String> accessControlAllowHeaders;
        private List<String> urlList;

        public Boolean getEnable() {
            return this.enable;
        }

        public List<String> getAccessControlAllowOrigin() {
            return this.accessControlAllowOrigin;
        }

        public Boolean getAccessControlAllowCredentials() {
            return this.accessControlAllowCredentials;
        }

        public List<String> getAccessControlExposeHeaders() {
            return this.accessControlExposeHeaders;
        }

        public Duration getAccessControlMaxAge() {
            return this.accessControlMaxAge;
        }

        public List<String> getAccessControlAllowMethods() {
            return this.accessControlAllowMethods;
        }

        public List<String> getAccessControlAllowHeaders() {
            return this.accessControlAllowHeaders;
        }

        public List<String> getUrlList() {
            return this.urlList;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public void setAccessControlAllowOrigin(List<String> accessControlAllowOrigin) {
            this.accessControlAllowOrigin = accessControlAllowOrigin;
        }

        public void setAccessControlAllowCredentials(Boolean accessControlAllowCredentials) {
            this.accessControlAllowCredentials = accessControlAllowCredentials;
        }

        public void setAccessControlExposeHeaders(List<String> accessControlExposeHeaders) {
            this.accessControlExposeHeaders = accessControlExposeHeaders;
        }

        public void setAccessControlMaxAge(Duration accessControlMaxAge) {
            this.accessControlMaxAge = accessControlMaxAge;
        }

        public void setAccessControlAllowMethods(List<String> accessControlAllowMethods) {
            this.accessControlAllowMethods = accessControlAllowMethods;
        }

        public void setAccessControlAllowHeaders(List<String> accessControlAllowHeaders) {
            this.accessControlAllowHeaders = accessControlAllowHeaders;
        }

        public void setUrlList(List<String> urlList) {
            this.urlList = urlList;
        }
    }

    public static class AnonymousProperties {
        private Boolean anonymousIsOpen = true;
        private String principal = "ANONYMOUS";
        private List<String> authorities = new ArrayList<String>(Collections.singletonList("ROLE_ANONYMOUS"));

        public Boolean getAnonymousIsOpen() {
            return this.anonymousIsOpen;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public List<String> getAuthorities() {
            return this.authorities;
        }

        public void setAnonymousIsOpen(Boolean anonymousIsOpen) {
            this.anonymousIsOpen = anonymousIsOpen;
        }

        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        public void setAuthorities(List<String> authorities) {
            this.authorities = authorities;
        }
    }

    public static class CsrfProperties {
        private Boolean csrfIsOpen = false;
        private Set<String> ignoringAntMatcherUrls = new HashSet<String>();
        private CsrfTokenRepositoryType tokenRepositoryType = CsrfTokenRepositoryType.SESSION;

        public Boolean getCsrfIsOpen() {
            return this.csrfIsOpen;
        }

        public Set<String> getIgnoringAntMatcherUrls() {
            return this.ignoringAntMatcherUrls;
        }

        public CsrfTokenRepositoryType getTokenRepositoryType() {
            return this.tokenRepositoryType;
        }

        public void setCsrfIsOpen(Boolean csrfIsOpen) {
            this.csrfIsOpen = csrfIsOpen;
        }

        public void setIgnoringAntMatcherUrls(Set<String> ignoringAntMatcherUrls) {
            this.ignoringAntMatcherUrls = ignoringAntMatcherUrls;
        }

        public void setTokenRepositoryType(CsrfTokenRepositoryType tokenRepositoryType) {
            this.tokenRepositoryType = tokenRepositoryType;
        }
    }

    public static class SessionProperties {
        private Boolean sessionNumberControl = false;
        private Integer maximumSessions = 1;
        private Boolean maxSessionsPreventsLogin = false;
        private Boolean enableSessionUrlRewriting = false;
        private SessionCreationPolicy sessionCreationPolicy = SessionCreationPolicy.ALWAYS;
        private String invalidSessionUrl = "/session/invalid";
        private String invalidSessionOfConcurrentUrl = "/";
        private String sessionCookieName = "JSESSIONID";

        public Boolean getSessionNumberControl() {
            return this.sessionNumberControl;
        }

        public Integer getMaximumSessions() {
            return this.maximumSessions;
        }

        public Boolean getMaxSessionsPreventsLogin() {
            return this.maxSessionsPreventsLogin;
        }

        public Boolean getEnableSessionUrlRewriting() {
            return this.enableSessionUrlRewriting;
        }

        public SessionCreationPolicy getSessionCreationPolicy() {
            return this.sessionCreationPolicy;
        }

        public String getInvalidSessionUrl() {
            return this.invalidSessionUrl;
        }

        public String getInvalidSessionOfConcurrentUrl() {
            return this.invalidSessionOfConcurrentUrl;
        }

        public String getSessionCookieName() {
            return this.sessionCookieName;
        }

        public void setSessionNumberControl(Boolean sessionNumberControl) {
            this.sessionNumberControl = sessionNumberControl;
        }

        public void setMaximumSessions(Integer maximumSessions) {
            this.maximumSessions = maximumSessions;
        }

        public void setMaxSessionsPreventsLogin(Boolean maxSessionsPreventsLogin) {
            this.maxSessionsPreventsLogin = maxSessionsPreventsLogin;
        }

        public void setEnableSessionUrlRewriting(Boolean enableSessionUrlRewriting) {
            this.enableSessionUrlRewriting = enableSessionUrlRewriting;
        }

        public void setSessionCreationPolicy(SessionCreationPolicy sessionCreationPolicy) {
            this.sessionCreationPolicy = sessionCreationPolicy;
        }

        public void setInvalidSessionUrl(String invalidSessionUrl) {
            this.invalidSessionUrl = invalidSessionUrl;
        }

        public void setInvalidSessionOfConcurrentUrl(String invalidSessionOfConcurrentUrl) {
            this.invalidSessionOfConcurrentUrl = invalidSessionOfConcurrentUrl;
        }

        public void setSessionCookieName(String sessionCookieName) {
            this.sessionCookieName = sessionCookieName;
        }
    }
}

