/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.filter.JsonRequestFilter;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.provider.UsernamePasswordAuthenticationProvider;

@Configuration
@Order(value=100)
@AutoConfigureAfter(value={SecurityAutoConfiguration.class})
public class ClientAutoConfigurerAware
implements HttpSecurityAware {
    public static final String FAVICON = "/**/favicon.ico";
    public static final String JS = "/**/*.js";
    public static final String CSS = "/**/*.css";
    public static final String HTML = "/**/*.html";
    private final ClientProperties clientProperties;
    @Autowired(required=false)
    private UmsUserDetailsService umsUserDetailsService;
    @Autowired(required=false)
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;
    private final PasswordEncoder passwordEncoder;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider;
    private final LogoutSuccessHandler logoutSuccessHandler;

    public ClientAutoConfigurerAware(ClientProperties clientProperties, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, PasswordEncoder passwordEncoder, UsernamePasswordAuthenticationProvider usernamePasswordAuthenticationProvider, LogoutSuccessHandler logoutSuccessHandler) {
        this.clientProperties = clientProperties;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.usernamePasswordAuthenticationProvider = usernamePasswordAuthenticationProvider;
        this.logoutSuccessHandler = logoutSuccessHandler;
        this.passwordEncoder = passwordEncoder;
    }

    public void configure(WebSecurity web) {
        String[] ignoringUrls = this.clientProperties.getIgnoringUrls();
        web.ignoring().mvcMatchers(HttpMethod.GET, new String[]{FAVICON, JS, CSS, HTML}).antMatchers(Optional.ofNullable(ignoringUrls).orElse(new String[0]));
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        if (this.umsUserDetailsService == null) {
            throw new RuntimeException("\u5fc5\u987b\u5b9e\u73b0 UmsUserDetailsService \u6216 top.dcenter.security.social.api.service.UmsSocialUserDetailsService \u62bd\u8c61\u7c7b");
        }
        auth.userDetailsService((UserDetailsService)this.umsUserDetailsService).passwordEncoder(this.passwordEncoder);
        auth.eraseCredentials(true);
    }

    public void postConfigure(HttpSecurity http) throws Exception {
        this.anonymousConfigurer(http);
        if (this.clientProperties.getSameOrigin().booleanValue()) {
            http.headers().frameOptions().sameOrigin();
        }
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        http.addFilterBefore((Filter)new JsonRequestFilter(), LogoutFilter.class);
        String loginUnAuthenticationRoutingUrl = this.clientProperties.getLoginUnAuthenticationRoutingUrl();
        if (!this.clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            loginUnAuthenticationRoutingUrl = this.clientProperties.getLoginPage();
        }
        FormLoginConfigurer httpSecurityFormLoginConfigurer = http.authenticationProvider((AuthenticationProvider)this.usernamePasswordAuthenticationProvider).formLogin();
        ((FormLoginConfigurer)((FormLoginConfigurer)httpSecurityFormLoginConfigurer.usernameParameter(this.clientProperties.getUsernameParameter()).passwordParameter(this.clientProperties.getPasswordParameter()).loginPage(loginUnAuthenticationRoutingUrl).loginProcessingUrl(this.clientProperties.getLoginProcessingUrl())).successHandler((AuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        if (this.authenticationDetailsSource != null) {
            httpSecurityFormLoginConfigurer.authenticationDetailsSource(this.authenticationDetailsSource);
        }
        this.logoutConfigurer(http);
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> permitAllMap = new HashMap<UriHttpMethodTuple, Object>(16);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)this.clientProperties.getFailureUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)this.clientProperties.getLoginPage()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)this.clientProperties.getLoginUnAuthenticationRoutingUrl()), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.POST, (String)this.clientProperties.getLoginProcessingUrl()), null);
        Set<String> permitUrls = this.clientProperties.getPermitUrls();
        this.permitUrlsFillingPermitAllMap(permitUrls, permitAllMap);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }

    private void anonymousConfigurer(HttpSecurity http) throws Exception {
        ClientProperties.AnonymousProperties anonymous = this.clientProperties.getAnonymous();
        String[] authorities = new String[anonymous.getAuthorities().size()];
        anonymous.getAuthorities().toArray(authorities);
        if (anonymous.getAnonymousIsOpen().booleanValue()) {
            http.anonymous().principal((Object)anonymous.getPrincipal()).authorities(authorities);
        } else {
            http.anonymous().disable();
        }
    }

    private void logoutConfigurer(HttpSecurity http) throws Exception {
        http.logout().logoutUrl(this.clientProperties.getLogoutUrl()).logoutSuccessHandler(this.logoutSuccessHandler).logoutSuccessUrl(this.clientProperties.getLogoutSuccessUrl()).deleteCookies(new String[]{this.clientProperties.getRememberMe().getRememberMeCookieName(), this.clientProperties.getSession().getSessionCookieName()}).clearAuthentication(true).invalidateHttpSession(true).permitAll();
    }
}

