/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.auth.session.strategy;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.SessionInformationExpiredEvent;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.util.AntPathMatcher;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.exception.ExpiredSessionDetectedException;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

public class ClientExpiredSessionStrategy
implements SessionInformationExpiredStrategy {
    private static final Logger log = LoggerFactory.getLogger(ClientExpiredSessionStrategy.class);
    private final RedirectStrategy redirectStrategy;
    private final LoginProcessType loginProcessType;
    private final String loginPage;
    private final RequestCache requestCache;
    private final AntPathMatcher matcher;

    public ClientExpiredSessionStrategy(ClientProperties clientProperties) {
        this.loginProcessType = clientProperties.getLoginProcessType();
        this.loginPage = clientProperties.getLoginPage();
        this.matcher = new AntPathMatcher();
        this.redirectStrategy = new DefaultRedirectStrategy();
        this.requestCache = new HttpSessionRequestCache();
    }

    public void onExpiredSessionDetected(SessionInformationExpiredEvent event) throws IOException {
        HttpServletRequest request = event.getRequest();
        HttpServletResponse response = event.getResponse();
        HttpSession session = request.getSession(true);
        try {
            session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
            String redirectUrl = AuthenticationUtil.determineInvalidSessionRedirectUrl(request, response, this.loginPage, this.matcher, this.requestCache);
            if (log.isDebugEnabled()) {
                log.debug("Session expired, starting new session and redirecting to '{}'", (Object)redirectUrl);
            }
            AuthenticationUtil.redirectProcessingByLoginProcessType(request, response, this.loginProcessType, this.redirectStrategy, ErrorCodeEnum.EXPIRED_SESSION, redirectUrl);
        }
        catch (Exception e) {
            log.error(String.format("SESSION\u8fc7\u671f\u5904\u7406\u5931\u8d25: error=%s, ip=%s, sid=%s, uri=%s", e.getMessage(), IpUtil.getRealIp((HttpServletRequest)request), session.getId(), request.getRequestURI()), (Throwable)e);
            throw new ExpiredSessionDetectedException(ErrorCodeEnum.SERVER_ERROR, session.getId());
        }
    }
}

