/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.util.CollectionUtils;
import top.dcenter.ums.security.common.api.tasks.handler.JobHandler;
import top.dcenter.ums.security.core.tasks.config.ScheduledExecutorAutoConfiguration;

@Configuration
@AutoConfigureAfter(value={ScheduledExecutorAutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer {
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    @Autowired(required=false)
    private Map<String, JobHandler> jobHandlerMap;

    public ScheduleAutoConfiguration(@Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor) {
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.jobTaskScheduledExecutor);
        if (CollectionUtils.isEmpty(this.jobHandlerMap)) {
            return;
        }
        this.jobHandlerMap.values().forEach(jobHandler -> taskRegistrar.addCronTask(() -> ((JobHandler)jobHandler).run(), jobHandler.cronExp()));
    }
}

