/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.utils.UrlUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;

public final class AuthenticationUtil {
    public static final String EXTRACT_USER_AGENT_REGEX = "[\\.\\d\\s\\(\\)]";

    private AuthenticationUtil() {
    }

    public static AbstractResponseJsonAuthenticationException getAbstractResponseJsonAuthenticationException(AuthenticationException exception) {
        AbstractResponseJsonAuthenticationException e = null;
        if (exception instanceof AbstractResponseJsonAuthenticationException) {
            e = (AbstractResponseJsonAuthenticationException)exception;
        }
        return e;
    }

    public static boolean isPermitUri(@NonNull HttpServletRequest request, @NonNull HttpSession session, @NonNull AntPathMatcher matcher) {
        String requestUri = UrlUtil.getUrlPathHelper().getPathWithinApplication(request);
        String method = request.getMethod();
        return AuthenticationUtil.isPermitUri(requestUri, method, session, matcher);
    }

    private static boolean isPermitUri(@NonNull String requestUri, @NonNull String method, @NonNull HttpSession session, @NonNull AntPathMatcher matcher) {
        Set permitAllSet = (Set)session.getServletContext().getAttribute("SERVLET_CONTEXT_PERMIT_ALL_SET_KEY");
        permitAllSet = Optional.ofNullable(permitAllSet).orElse(new HashSet(0));
        for (UriHttpMethodTuple tuple : permitAllSet) {
            if (!matcher.match(tuple.getUri(), requestUri)) continue;
            HttpMethod httpMethod = tuple.getMethod();
            if (httpMethod == null) {
                return true;
            }
            String name = httpMethod.name();
            if (!name.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean authenticationFailureProcessing(HttpServletResponse response, HttpServletRequest request, AuthenticationException exception, AbstractResponseJsonAuthenticationException e, LoginProcessType loginProcessType) throws IOException {
        boolean isJsonProcessType = LoginProcessType.JSON.equals((Object)loginProcessType);
        if (isJsonProcessType || JsonUtil.isAjaxOrJson((HttpServletRequest)request)) {
            int status = HttpStatus.UNAUTHORIZED.value();
            ResponseResult result = e != null ? ResponseResult.fail((ErrorCodeEnum)e.getErrorCodeEnum(), (Object)e.getData()) : ResponseResult.fail((String)exception.getMessage(), (ErrorCodeEnum)ErrorCodeEnum.UNAUTHORIZED);
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)status, (String)JsonUtil.toJsonString((Object)result));
            return true;
        }
        return false;
    }

    public static String extractUserAgent(String userAgent) {
        return userAgent.replaceAll(EXTRACT_USER_AGENT_REGEX, "");
    }

    public static void redirectProcessingLogoutByLoginProcessType(HttpServletRequest request, HttpServletResponse response, String logoutSuccessUrl, LoginProcessType loginProcessType, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum) throws IOException {
        AuthenticationUtil.redirectProcessing(request, response, loginProcessType, redirectStrategy, errorCodeEnum, logoutSuccessUrl);
    }

    public static void redirectProcessingByLoginProcessType(HttpServletRequest request, HttpServletResponse response, LoginProcessType loginProcessType, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        String referer = Optional.ofNullable(request.getHeader("Referer")).orElse(redirectUrl);
        AuthenticationUtil.redirectProcessing(request, response, loginProcessType, redirectStrategy, errorCodeEnum, referer);
    }

    public static String determineInvalidSessionRedirectUrl(HttpServletRequest request, HttpServletResponse response, String destinationUrl, AntPathMatcher matcher, RequestCache requestCache) {
        HttpSession session = request.getSession();
        String redirectUrl = destinationUrl;
        String originalUrl = null;
        String queryString = request.getQueryString();
        if (StringUtils.hasText((String)queryString)) {
            queryString = "?" + queryString;
        }
        if (AuthenticationUtil.isPermitUri(request, session, matcher)) {
            redirectUrl = request.getRequestURL().toString() + Optional.ofNullable(queryString).orElse("");
        } else {
            SavedRequest savedRequest = requestCache.getRequest(request, response);
            originalUrl = request.getRequestURL().toString() + Optional.ofNullable(queryString).orElse("");
            if (savedRequest != null) {
                originalUrl = Optional.ofNullable(savedRequest.getRedirectUrl()).orElse(originalUrl);
            }
        }
        session = request.getSession();
        session.removeAttribute("SESSION_ENHANCE_CHECK_KEY");
        if (originalUrl != null) {
            session.setAttribute("SESSION_REDIRECT_URL_KEY", (Object)originalUrl);
        }
        return redirectUrl;
    }

    public static String getOriginalUrl(RequestCache requestCache, HttpServletRequest request, HttpServletResponse response, String defaultRedirectUrl) throws IOException {
        HttpSession session;
        String originalUrl;
        SavedRequest savedRequest = requestCache.getRequest(request, response);
        String redirectUrl = defaultRedirectUrl;
        if (savedRequest != null) {
            redirectUrl = Optional.ofNullable(savedRequest.getRedirectUrl()).orElse(redirectUrl);
        }
        if (StringUtils.hasText((String)(originalUrl = (String)(session = request.getSession()).getAttribute("SESSION_REDIRECT_URL_KEY")))) {
            redirectUrl = originalUrl;
            session.removeAttribute("SESSION_REDIRECT_URL_KEY");
        }
        return redirectUrl;
    }

    private static void redirectProcessing(HttpServletRequest request, HttpServletResponse response, LoginProcessType loginProcessType, RedirectStrategy redirectStrategy, ErrorCodeEnum errorCodeEnum, String redirectUrl) throws IOException {
        if (LoginProcessType.JSON.equals((Object)loginProcessType)) {
            int status = HttpStatus.UNAUTHORIZED.value();
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)status, (String)JsonUtil.toJsonString((Object)ResponseResult.fail((ErrorCodeEnum)errorCodeEnum, (Object)redirectUrl)));
            return;
        }
        redirectStrategy.sendRedirect(request, response, redirectUrl);
    }
}

