/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.filter.redirect;

import javax.servlet.http.HttpServletRequest;
import org.springframework.lang.Nullable;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.exception.Auth2Exception;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2AuthorizationRequestResolver;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;

public final class Auth2DefaultRequestResolver
implements Auth2AuthorizationRequestResolver {
    private static final String REGISTRATION_ID_URI_VARIABLE_NAME = "registrationId";
    private final AntPathRequestMatcher authorizationRequestMatcher;

    public Auth2DefaultRequestResolver(String authorizationRequestBaseUri) {
        Assert.hasText((String)authorizationRequestBaseUri, (String)"authorizationRequestBaseUri cannot be empty");
        this.authorizationRequestMatcher = new AntPathRequestMatcher(authorizationRequestBaseUri + "/{" + REGISTRATION_ID_URI_VARIABLE_NAME + "}");
    }

    @Override
    public Auth2DefaultRequest resolve(HttpServletRequest request) throws Auth2Exception {
        if (StringUtils.hasText((String)request.getParameter("state"))) {
            return null;
        }
        String registrationId = this.resolveRegistrationId(request);
        return this.getAuth2DefaultRequest(registrationId);
    }

    @Override
    public Auth2DefaultRequest resolve(HttpServletRequest request, String registrationId) throws Auth2Exception {
        if (StringUtils.hasText((String)request.getParameter("state"))) {
            return null;
        }
        return this.getAuth2DefaultRequest(registrationId);
    }

    public String resolveRegistrationId(HttpServletRequest request) {
        if (this.authorizationRequestMatcher.matches(request)) {
            return (String)this.authorizationRequestMatcher.matcher(request).getVariables().get(REGISTRATION_ID_URI_VARIABLE_NAME);
        }
        return null;
    }

    @Nullable
    private Auth2DefaultRequest getAuth2DefaultRequest(@Nullable String registrationId) throws Auth2Exception {
        if (registrationId == null) {
            return null;
        }
        Auth2DefaultRequest auth2DefaultRequest = Auth2RequestHolder.getAuth2DefaultRequest(registrationId);
        if (auth2DefaultRequest == null) {
            throw new Auth2Exception(ErrorCodeEnum.AUTH2_PROVIDER_NOT_SUPPORT, registrationId);
        }
        return auth2DefaultRequest;
    }
}

