/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.advice;

import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.exception.AbstractResponseJsonAuthenticationException;
import top.dcenter.ums.security.core.exception.Auth2Exception;
import top.dcenter.ums.security.core.exception.BusinessException;
import top.dcenter.ums.security.core.exception.RefreshTokenFailureException;
import top.dcenter.ums.security.core.mdc.utils.MdcUtil;

@Order(value=102)
@ControllerAdvice
public class Auth2ControllerAdviceHandler {
    @ExceptionHandler(value={AbstractResponseJsonAuthenticationException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ResponseResult abstractResponseJsonAuthenticationException(AbstractResponseJsonAuthenticationException ex) {
        String errorMsg = ex.getMessage();
        return ResponseResult.fail((String)errorMsg, (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={Auth2Exception.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    public ResponseResult auth2Exception(Auth2Exception ex) {
        return ResponseResult.fail((String)ex.getMessage(), (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={RefreshTokenFailureException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseResult refreshTokenFailureException(RefreshTokenFailureException ex) {
        return ResponseResult.fail((String)ex.getMessage(), (ErrorCodeEnum)ex.getErrorCodeEnum(), (Object)MdcUtil.getMdcTraceId());
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ResponseResult businessException(BusinessException e) {
        return ResponseResult.fail((String)e.getMessage(), (ErrorCodeEnum)ErrorCodeEnum.BUSINESS_ERROR, (Object)MdcUtil.getMdcTraceId());
    }
}

