/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.api.oauth.justauth.request;

import com.xkcoding.http.exception.SimpleHttpException;
import java.time.Instant;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UuidUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.api.oauth.entity.AuthTokenPo;
import top.dcenter.ums.security.core.api.oauth.justauth.cache.Auth2StateCache;
import top.dcenter.ums.security.core.api.oauth.justauth.enums.CacheKeyStrategy;
import top.dcenter.ums.security.core.exception.RefreshTokenFailureException;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateSessionCache;

public interface Auth2DefaultRequest {
    public AuthResponse login(AuthCallback var1);

    public String getProviderId();

    public AuthSource getAuthSource();

    public AuthStateCache getAuthStateCache();

    public String authorize(String var1);

    public AuthToken getAccessToken(AuthCallback var1) throws SimpleHttpException;

    public AuthUser getUserInfo(AuthToken var1) throws SimpleHttpException;

    public AuthTokenPo refreshToken(AuthTokenPo var1) throws SimpleHttpException, AuthException, RefreshTokenFailureException;

    default public String generateState() {
        return UuidUtils.getUUID();
    }

    public static String determineState(@NonNull AuthStateCache authStateCache, @NonNull String state, @NonNull AuthSource source) {
        if (authStateCache instanceof Auth2StateCache) {
            Auth2StateCache stateCache = (Auth2StateCache)authStateCache;
            CacheKeyStrategy cacheKeyStrategy = stateCache.getCacheKeyStrategy();
            switch (cacheKeyStrategy) {
                case PROVIDER_ID: {
                    return source.getName();
                }
            }
        }
        return state;
    }

    public static void removeStateCacheOfSessionCache(@NonNull AuthStateCache authStateCache, @NonNull AuthSource source) {
        if (authStateCache instanceof AuthStateSessionCache) {
            AuthStateSessionCache stateCache = (AuthStateSessionCache)authStateCache;
            stateCache.remove(source.getName());
        }
    }

    @NonNull
    public static AuthTokenPo getAuthTokenPo(Integer timeout, Long tokenId, AuthResponse authResponse) throws RefreshTokenFailureException {
        Object data;
        if (authResponse.ok() && (data = authResponse.getData()) instanceof AuthToken) {
            AuthToken token = (AuthToken)data;
            AuthTokenPo tokenPo = new AuthTokenPo();
            tokenPo.setId(tokenId);
            BeanUtils.copyProperties((Object)token, (Object)((Object)tokenPo));
            int expireIn = token.getExpireIn();
            Auth2DefaultRequest.expireIn2Timestamp(timeout, expireIn, tokenPo);
            return tokenPo;
        }
        throw new RefreshTokenFailureException(ErrorCodeEnum.REFRESH_TOKEN_FAILURE, authResponse.getMsg(), String.valueOf(tokenId));
    }

    public static <T extends AuthTokenPo> void expireIn2Timestamp(@NonNull Integer timeout, @Nullable Integer expireIn, @NonNull T authToken) {
        authToken.setExpireTime(Auth2DefaultRequest.expireIn2Timestamp(timeout, expireIn));
    }

    public static long expireIn2Timestamp(@NonNull Integer timeout, @Nullable Integer expireIn) {
        if (expireIn == null || expireIn < 1) {
            return -1L;
        }
        return Instant.now().plusSeconds(expireIn.intValue()).minusMillis(timeout.intValue()).toEpochMilli();
    }

    public static AuthResponse responseError(Exception e) {
        int errorCode = AuthResponseStatus.FAILURE.getCode();
        String errorMsg = e.getMessage();
        if (e instanceof AuthException) {
            AuthException authException = (AuthException)e;
            errorCode = authException.getErrorCode();
            if (StringUtils.isNotEmpty((String)authException.getErrorMsg())) {
                errorMsg = authException.getErrorMsg();
            }
        }
        return AuthResponse.builder().code(errorCode).msg(errorMsg).build();
    }
}

