/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.util.concurrent.ExecutorService;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import top.dcenter.ums.security.common.api.userdetails.converter.AuthenticationToUserDetailsConverter;
import top.dcenter.ums.security.common.propertis.RememberMeProperties;
import top.dcenter.ums.security.common.utils.AppContextUtil;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationFailureHandler;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.api.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.api.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.api.oauth.state.service.Auth2StateCoder;
import top.dcenter.ums.security.core.api.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.api.tenant.handler.TenantContextHolder;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.filter.login.Auth2LoginAuthenticationFilter;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2DefaultRequestRedirectFilter;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.provider.Auth2LoginAuthenticationProvider;
import top.dcenter.ums.security.jwt.claims.service.GenerateClaimsSetService;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
public class Auth2AutoConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    private final Auth2Properties auth2Properties;
    private final UmsUserDetailsService umsUserDetailsService;
    private final Auth2UserService auth2UserService;
    private final ConnectionService connectionSignUp;
    private final ExecutorService updateConnectionTaskExecutor;
    private final BaseAuthenticationFailureHandler baseAuthenticationFailureHandler;
    private final BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler;
    private final RedisConnectionFactory redisConnectionFactory;
    private final AuthenticationToUserDetailsConverter authenticationToUserDetailsConverter;
    @Autowired(required=false)
    private Auth2StateCoder auth2StateCoder;
    @Autowired
    private UmsUserDetailsService userDetailsService;
    @Autowired(required=false)
    private PersistentTokenRepository persistentTokenRepository;
    @Autowired(required=false)
    private TenantContextHolder tenantContextHolder;
    @Autowired(required=false)
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource;
    @Autowired(required=false)
    private RememberMeProperties rememberMe;
    @Autowired(required=false)
    private RememberMeServices rememberMeServices;
    @Autowired(required=false)
    private GenerateClaimsSetService generateClaimsSetService;

    public Auth2AutoConfigurer(Auth2Properties auth2Properties, UmsUserDetailsService umsUserDetailsService, Auth2UserService auth2UserService, ConnectionService connectionSignUp, @Qualifier(value="updateConnectionTaskExecutor") ExecutorService updateConnectionTaskExecutor, BaseAuthenticationFailureHandler baseAuthenticationFailureHandler, BaseAuthenticationSuccessHandler baseAuthenticationSuccessHandler, @Autowired(required=false) RedisConnectionFactory redisConnectionFactory, @Autowired(required=false) AuthenticationToUserDetailsConverter authenticationToUserDetailsConverter) {
        this.auth2Properties = auth2Properties;
        this.umsUserDetailsService = umsUserDetailsService;
        this.auth2UserService = auth2UserService;
        this.connectionSignUp = connectionSignUp;
        this.updateConnectionTaskExecutor = updateConnectionTaskExecutor;
        this.baseAuthenticationFailureHandler = baseAuthenticationFailureHandler;
        this.baseAuthenticationSuccessHandler = baseAuthenticationSuccessHandler;
        this.redisConnectionFactory = redisConnectionFactory;
        this.baseAuthenticationSuccessHandler.setAuth2RedirectUrl(auth2Properties.getRedirectUrlPrefix());
        this.authenticationToUserDetailsConverter = authenticationToUserDetailsConverter;
    }

    public void configure(HttpSecurity http) {
        String filterProcessesUrl = this.auth2Properties.getRedirectUrlPrefix();
        Auth2LoginAuthenticationFilter auth2LoginAuthenticationFilter = new Auth2LoginAuthenticationFilter(filterProcessesUrl, this.auth2Properties.getSignUpUrl(), this.authenticationDetailsSource, this.redisConnectionFactory);
        AuthenticationManager sharedObject = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        auth2LoginAuthenticationFilter.setAuthenticationManager(sharedObject);
        AppContextUtil.registerHandlerAndRememberMeServices((AbstractAuthenticationProcessingFilter)auth2LoginAuthenticationFilter, (BaseAuthenticationSuccessHandler)this.baseAuthenticationSuccessHandler, (BaseAuthenticationFailureHandler)this.baseAuthenticationFailureHandler, (PersistentTokenRepository)this.persistentTokenRepository, (UmsUserDetailsService)this.userDetailsService, (RememberMeServices)this.rememberMeServices, (RememberMeProperties)this.rememberMe);
        http.addFilterBefore((Filter)this.postProcess((Object)auth2LoginAuthenticationFilter), OAuth2AuthorizationRequestRedirectFilter.class);
        String authorizationRequestBaseUri = this.auth2Properties.getAuthLoginUrlPrefix();
        Auth2DefaultRequestRedirectFilter auth2DefaultRequestRedirectFilter = new Auth2DefaultRequestRedirectFilter(authorizationRequestBaseUri, this.auth2StateCoder, this.tenantContextHolder, (SimpleUrlAuthenticationFailureHandler)this.baseAuthenticationFailureHandler);
        http.addFilterBefore((Filter)this.postProcess((Object)auth2DefaultRequestRedirectFilter), AbstractPreAuthenticatedProcessingFilter.class);
        Auth2LoginAuthenticationProvider auth2LoginAuthenticationProvider = new Auth2LoginAuthenticationProvider(this.auth2UserService, this.connectionSignUp, this.umsUserDetailsService, this.updateConnectionTaskExecutor, this.auth2Properties.getAutoSignUp(), this.generateClaimsSetService, this.auth2Properties.getTemporaryUserAuthorities(), this.auth2Properties.getTemporaryUserPassword(), this.authenticationToUserDetailsConverter);
        http.authenticationProvider((AuthenticationProvider)this.postProcess(auth2LoginAuthenticationProvider));
    }
}

