/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.executor.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import top.dcenter.ums.security.common.executor.DefaultThreadFactory;
import top.dcenter.ums.security.common.executor.MdcThreadPoolTaskExecutor;
import top.dcenter.ums.security.core.executor.config.ExecutorPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.executor.properties.ExecutorProperties;

@Configuration
@AutoConfigureAfter(value={ExecutorPropertiesAutoConfiguration.class})
@EnableScheduling
public class ExecutorAutoConfiguration
implements DisposableBean {
    private final ExecutorProperties executorProperties;
    private ExecutorService updateConnectionExecutorService;
    private ExecutorService refreshTokenExecutorService;

    public ExecutorAutoConfiguration(ExecutorProperties executorProperties) {
        this.executorProperties = executorProperties;
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
    public ExecutorService refreshTokenTaskExecutor() {
        ExecutorProperties.RefreshTokenExecutorProperties refreshToken = this.executorProperties.getRefreshToken();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(refreshToken.getCorePoolSize().intValue(), refreshToken.getMaximumPoolSize().intValue(), (long)refreshToken.getKeepAliveTime().intValue(), refreshToken.getTimeUnit(), new LinkedBlockingQueue(refreshToken.getBlockingQueueCapacity()), this.getThreadFactory(refreshToken.getPoolName()), refreshToken.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.refreshTokenExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
    public ExecutorService updateConnectionTaskExecutor() {
        ExecutorProperties.UserConnectionUpdateExecutorProperties userConnectionUpdate = this.executorProperties.getUserConnectionUpdate();
        MdcThreadPoolTaskExecutor threadPoolExecutor = new MdcThreadPoolTaskExecutor(userConnectionUpdate.getCorePoolSize().intValue(), userConnectionUpdate.getMaximumPoolSize().intValue(), (long)userConnectionUpdate.getKeepAliveTime().intValue(), userConnectionUpdate.getTimeUnit(), new LinkedBlockingQueue(userConnectionUpdate.getBlockingQueueCapacity()), this.getThreadFactory(userConnectionUpdate.getPoolName()), userConnectionUpdate.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.updateConnectionExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void shutdown() throws Exception {
        if (this.updateConnectionExecutorService != null) {
            this.updateConnectionExecutorService.shutdown();
            this.updateConnectionExecutorService.awaitTermination(this.executorProperties.getUserConnectionUpdate().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.updateConnectionExecutorService.isTerminated()) {
                this.updateConnectionExecutorService.shutdownNow();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.refreshTokenExecutorService != null) {
            this.refreshTokenExecutorService.shutdown();
            this.refreshTokenExecutorService.awaitTermination(this.executorProperties.getRefreshToken().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.refreshTokenExecutorService.isTerminated()) {
                this.refreshTokenExecutorService.shutdownNow();
            }
        }
    }
}

