/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.deserializes;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;

public class AuthUserJsonDeserializer
extends StdDeserializer<AuthUser> {
    protected AuthUserJsonDeserializer() {
        super(AuthUser.class);
    }

    public AuthUser deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectMapper mapper = (ObjectMapper)p.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(p);
        String uuid = jsonNode.get("uuid").asText();
        String username = jsonNode.get("username").asText();
        String nickname = jsonNode.get("nickname").asText(null);
        String avatar = jsonNode.get("avatar").asText(null);
        String blog = jsonNode.get("blog").asText(null);
        String company = jsonNode.get("company").asText(null);
        String location = jsonNode.get("location").asText(null);
        String email = jsonNode.get("email").asText(null);
        String remark = jsonNode.get("remark").asText(null);
        AuthUserGender gender = (AuthUserGender)mapper.convertValue((Object)jsonNode.get("gender"), (TypeReference)new TypeReference<AuthUserGender>(){});
        String source = jsonNode.get("source").asText(null);
        AuthToken token = (AuthToken)mapper.convertValue((Object)jsonNode.get("token"), (TypeReference)new TypeReference<AuthToken>(){});
        JsonNode rawUserInfoNode = jsonNode.get("rawUserInfo");
        String rawUserInfoString = mapper.writeValueAsString((Object)rawUserInfoNode);
        JSONObject rawUserInfo = (JSONObject)JSONObject.parse((String)rawUserInfoString);
        rawUserInfo.remove((Object)"@class");
        return AuthUser.builder().uuid(uuid).username(username).nickname(nickname).avatar(avatar).blog(blog).company(company).location(location).email(email).remark(remark).gender(gender).source(source).token(token).rawUserInfo(rawUserInfo).build();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    public static interface AuthTokenMixin {
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=AuthUserJsonDeserializer.class)
    public static interface AuthUserMixin {
    }
}

