/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import top.dcenter.ums.security.common.api.config.HttpSecurityAware;
import top.dcenter.ums.security.common.bean.UriHttpMethodTuple;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfigurer;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
public class Auth2AutoHttpSecurityAware
implements HttpSecurityAware {
    private final Auth2AutoConfigurer auth2AutoConfigurer;
    private final Auth2Properties auth2Properties;

    public Auth2AutoHttpSecurityAware(Auth2AutoConfigurer auth2AutoConfigurer, Auth2Properties auth2Properties) {
        this.auth2AutoConfigurer = auth2AutoConfigurer;
        this.auth2Properties = auth2Properties;
    }

    public void preConfigure(HttpSecurity http) throws Exception {
        if (this.auth2AutoConfigurer != null) {
            http.apply((SecurityConfigurerAdapter)this.auth2AutoConfigurer);
        }
    }

    public void configure(WebSecurity web) {
    }

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
    }

    public void postConfigure(HttpSecurity http) throws Exception {
    }

    public Map<String, Map<UriHttpMethodTuple, Set<String>>> getAuthorizeRequestMap() {
        HashMap<UriHttpMethodTuple, Object> permitAllMap = new HashMap<UriHttpMethodTuple, Object>(16);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)(this.auth2Properties.getRedirectUrlPrefix() + "/*")), null);
        permitAllMap.put(UriHttpMethodTuple.tuple((HttpMethod)HttpMethod.GET, (String)(this.auth2Properties.getAuthLoginUrlPrefix() + "/*")), null);
        HashMap<String, Map<UriHttpMethodTuple, Set<String>>> resultMap = new HashMap<String, Map<UriHttpMethodTuple, Set<String>>>(1);
        resultMap.put("permitAll", permitAllMap);
        return resultMap;
    }
}

