/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.deserializes;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class UserDeserializer
extends StdDeserializer<User> {
    public UserDeserializer() {
        super(User.class);
    }

    public User deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectMapper mapper = (ObjectMapper)jp.getCodec();
        JsonNode jsonNode = (JsonNode)mapper.readTree(jp);
        Set authorities = (Set)mapper.convertValue((Object)jsonNode.get("authorities"), (TypeReference)new TypeReference<Set<SimpleGrantedAuthority>>(){});
        JsonNode password = this.readJsonNode(jsonNode, "password");
        User result = new User(this.readJsonNode(jsonNode, "username").asText(), password.asText(""), this.readJsonNode(jsonNode, "enabled").asBoolean(), this.readJsonNode(jsonNode, "accountNonExpired").asBoolean(), this.readJsonNode(jsonNode, "credentialsNonExpired").asBoolean(), this.readJsonNode(jsonNode, "accountNonLocked").asBoolean(), (Collection)authorities);
        if (password.asText(null) == null) {
            result.eraseCredentials();
        }
        return result;
    }

    private JsonNode readJsonNode(JsonNode jsonNode, String field) {
        if (jsonNode.has(field)) {
            return jsonNode.get(field);
        }
        return MissingNode.getInstance();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="@class")
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonDeserialize(using=UserDeserializer.class)
    public static interface UserMixin {
    }
}

