/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth.cache;

import java.time.Instant;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import top.dcenter.ums.security.core.api.oauth.justauth.cache.Auth2StateCache;
import top.dcenter.ums.security.core.api.oauth.justauth.enums.CacheKeyStrategy;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;

public class AuthStateSessionCache
implements Auth2StateCache {
    private static final String DELIMITER = "_";
    private final JustAuthProperties justAuthProperties;

    public AuthStateSessionCache(Auth2Properties auth2Properties) {
        this.justAuthProperties = auth2Properties.getJustAuth();
    }

    public void cache(String key, String value) {
        this.cache(key, value, this.justAuthProperties.getTimeout().toMillis());
    }

    public void cache(String key, String value, long timeout) {
        long epochMilli = Instant.now().plusMillis(timeout).toEpochMilli();
        RequestContextHolder.currentRequestAttributes().setAttribute(this.justAuthProperties.getCacheKeyPrefix() + key, (Object)(value + DELIMITER + epochMilli), 1);
    }

    public String get(String key) {
        String sessionKey;
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        String result = (String)requestAttributes.getAttribute(sessionKey = this.justAuthProperties.getCacheKeyPrefix() + key, 1);
        if (!StringUtils.hasText((String)result)) {
            return null;
        }
        int index = result.lastIndexOf(DELIMITER);
        long timeout = Long.parseLong(result.substring(index + 1));
        if (Instant.now().toEpochMilli() > timeout) {
            requestAttributes.removeAttribute(sessionKey, 1);
            return null;
        }
        return result.substring(0, index);
    }

    public void remove(String key) {
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        String sessionKey = this.justAuthProperties.getCacheKeyPrefix() + key;
        requestAttributes.removeAttribute(sessionKey, 1);
    }

    public boolean containsKey(String key) {
        return StringUtils.hasText((String)this.get(key));
    }

    @Override
    public CacheKeyStrategy getCacheKeyStrategy() {
        return CacheKeyStrategy.PROVIDER_ID;
    }
}

