/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.filter;

import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.util.NestedServletException;
import top.dcenter.ums.security.common.enums.ErrorCodeEnum;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.exception.BusinessException;

public class ErrorHandlerFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandlerFilter.class);

    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, FilterChain filterChain) throws IOException {
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException | BusinessException e) {
            ErrorCodeEnum errorCodeEnum;
            log.error(e.getMessage(), e);
            int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
            if (e instanceof AuthenticationException) {
                status = HttpStatus.UNAUTHORIZED.value();
                errorCodeEnum = ErrorCodeEnum.UNAUTHORIZED;
            } else {
                errorCodeEnum = ((BusinessException)e).getErrorCodeEnum();
            }
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)status, (String)JsonUtil.toJsonString((Object)ResponseResult.fail((ErrorCodeEnum)errorCodeEnum, (Object)e.getMessage())));
        }
        catch (NestedServletException e) {
            String msg = e.getMessage();
            log.error(msg, (Throwable)e);
            Throwable cause = e.getCause();
            int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
            ErrorCodeEnum errorCode = ErrorCodeEnum.INTERNAL_SERVER_ERROR;
            String errorMsg = msg;
            if (cause instanceof MaxUploadSizeExceededException) {
                MaxUploadSizeExceededException maxUploadSizeExceededException = (MaxUploadSizeExceededException)cause;
                errorCode = ErrorCodeEnum.MAX_UPLOAD_SIZE_EXCEEDED_EXCEPTION;
                String message = maxUploadSizeExceededException.getMessage();
                errorMsg = Objects.nonNull(message) ? message.substring(message.lastIndexOf(":") + 2) : errorCode.getMsg();
            }
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)status, (String)JsonUtil.toJsonString((Object)ResponseResult.fail((ErrorCodeEnum)errorCode, (Object)errorMsg)));
        }
        catch (ServletException e) {
            log.error(e.getMessage(), (Throwable)e);
            int status = HttpStatus.INTERNAL_SERVER_ERROR.value();
            JsonUtil.responseWithJson((HttpServletResponse)response, (int)status, (String)JsonUtil.toJsonString((Object)ResponseResult.fail((ErrorCodeEnum)ErrorCodeEnum.INTERNAL_SERVER_ERROR, (Object)e.getMessage())));
        }
    }
}

