/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.handler;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.common.enums.LoginProcessType;
import top.dcenter.ums.security.common.utils.IpUtil;
import top.dcenter.ums.security.common.utils.JsonUtil;
import top.dcenter.ums.security.common.utils.UuidUtils;
import top.dcenter.ums.security.common.vo.ResponseResult;
import top.dcenter.ums.security.core.api.authentication.handler.BaseAuthenticationSuccessHandler;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.util.MvcUtil;
import top.dcenter.ums.security.core.util.RequestUtil;
import top.dcenter.ums.security.core.vo.AuthTokenVo;
import top.dcenter.ums.security.jwt.JwtContext;
import top.dcenter.ums.security.properties.UmsProperties;

public class UmsAuthenticationSuccessHandler
extends BaseAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(UmsAuthenticationSuccessHandler.class);
    protected final RequestCache requestCache;
    protected final LoginProcessType loginProcessType;
    private final RedisConnectionFactory redisConnectionFactory;
    private final UmsProperties umsProperties;
    private final String domain;
    private final String refreshTokenHeaderName;

    public UmsAuthenticationSuccessHandler(@NonNull ClientProperties clientProperties, @Nullable String auth2RedirectUrl, @NonNull String domain, @NonNull String refreshTokenHeaderName, @NonNull RedisConnectionFactory redisConnectionFactory, @NonNull UmsProperties umsProperties) {
        this.redisConnectionFactory = redisConnectionFactory;
        this.umsProperties = umsProperties;
        this.auth2RedirectUrl = auth2RedirectUrl;
        this.domain = domain;
        this.refreshTokenHeaderName = refreshTokenHeaderName;
        this.requestCache = new HttpSessionRequestCache();
        this.loginProcessType = clientProperties.getLoginProcessType();
        this.setTargetUrlParameter(clientProperties.getTargetUrlParameter());
        this.setUseReferer(clientProperties.getUseReferer());
        this.setAlwaysUseDefaultTargetUrl(clientProperties.getAlwaysUseDefaultTargetUrl());
        this.ignoreUrls.add(clientProperties.getLoginPage());
        this.ignoreUrls.add(clientProperties.getLogoutUrl());
        super.setDefaultTargetUrl(clientProperties.getSuccessUrl());
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String username = authentication.getName();
        String ip = IpUtil.getRealIp((HttpServletRequest)request);
        String userAgent = request.getHeader("User-Agent");
        HttpSession session = request.getSession(true);
        String sid = session.getId();
        log.info("\u767b\u5f55\u6210\u529f: uid={}, ip={}, ua={}, sid={}", new Object[]{username, ip, userAgent, sid});
        try {
            String targetUrl = this.determineTargetUrl(request, response);
            if (Objects.nonNull(this.auth2RedirectUrl) && request.getServletPath().startsWith(this.auth2RedirectUrl) && authentication instanceof AbstractOAuth2TokenAuthenticationToken) {
                AbstractOAuth2TokenAuthenticationToken jwtAuthentication = (AbstractOAuth2TokenAuthenticationToken)authentication;
                this.oauth2CallbackUrl(request, response, targetUrl, (AbstractOAuth2TokenAuthenticationToken<Jwt>)jwtAuthentication);
                return;
            }
            if (LoginProcessType.JSON.equals((Object)this.loginProcessType) || JsonUtil.isAjaxOrJson((HttpServletRequest)request)) {
                this.clearAuthenticationAttributes(request);
                AuthTokenVo authTokenVo = new AuthTokenVo(username, username, null, null, null, null, this.getJsonTargetUrl(targetUrl, request), null);
                String jwtStringIfAllowBodyParameter = JwtContext.getJwtStringIfAllowBodyParameter((Authentication)authentication);
                if (StringUtils.hasText((String)jwtStringIfAllowBodyParameter)) {
                    authTokenVo.setToken(jwtStringIfAllowBodyParameter);
                    authTokenVo.setExpiresIn(Optional.ofNullable(JwtContext.getJwtExpiresInByAuthentication((Authentication)authentication)).orElse(-1L));
                }
                if (JwtContext.isRefreshJwtByRefreshToken().booleanValue()) {
                    authTokenVo.setRefreshToken(JwtContext.getJwtRefreshTokenFromSession());
                }
                this.clearAuthenticationAttributes(request);
                JsonUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)JsonUtil.toJsonString((Object)ResponseResult.success(null, (Object)authTokenVo)));
                return;
            }
            this.clearAuthenticationAttributes(request);
            session.removeAttribute("TEMPORARY_JWT_REFRESH_TOKEN");
            this.getRedirectStrategy().sendRedirect(request, response, targetUrl);
        }
        catch (Exception e) {
            log.error(String.format("\u8bbe\u7f6e\u767b\u5f55\u6210\u529f\u540e\u8df3\u8f6c\u7684URL\u5931\u8d25: error=%s, uid=%s, ip=%s, ua=%s, sid=%s", e.getMessage(), username, ip, userAgent, sid), (Throwable)e);
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String referer;
        String defaultTargetUrl = this.getDefaultTargetUrl();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (this.isAlwaysUseDefaultTargetUrl()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Using default url %s", (Object)defaultTargetUrl));
            }
            this.requestCache.removeRequest(request, response);
            return defaultTargetUrl;
        }
        if (savedRequest != null) {
            String redirectUrl = savedRequest.getRedirectUrl();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"using url %s from default saved request %s", (Object)redirectUrl));
            }
            return redirectUrl;
        }
        String targetUrl = null;
        String targetUrlParameter = this.getTargetUrlParameter();
        if (targetUrlParameter != null) {
            targetUrl = request.getParameter(targetUrlParameter);
            if (StringUtils.hasText((String)targetUrl) && MvcUtil.isSelfTopDomain((String)targetUrl)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)LogMessage.format((String)"Using url %s from request parameter %s", (Object)targetUrl, (Object)targetUrlParameter));
                }
                return targetUrl;
            }
            targetUrl = null;
        }
        if (this.useReferer && StringUtils.hasText((String)(referer = request.getHeader("Referer"))) && MvcUtil.isSelfTopDomain((String)referer)) {
            targetUrl = referer;
        }
        if (!StringUtils.hasText((String)targetUrl) || this.isIgnoreUrl(targetUrl, request)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)LogMessage.format((String)"Using default url %s", (Object)defaultTargetUrl));
            }
            return defaultTargetUrl;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)LogMessage.format((String)"Using url %s from Referer header", (Object)targetUrl));
        }
        return targetUrl;
    }

    public void setUseReferer(boolean useReferer) {
        super.setUseReferer(useReferer);
        this.useReferer = useReferer;
    }

    private void oauth2CallbackUrl(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull String targetUrl, @NonNull AbstractOAuth2TokenAuthenticationToken<Jwt> jwtAuthentication) throws IOException {
        String uuid = UuidUtils.getUUID();
        request.getSession().setAttribute(this.umsProperties.getOauth2TokenParamName(), (Object)uuid);
        String tkValue = ((Jwt)jwtAuthentication.getToken()).getTokenValue();
        String delimiterOfTokenAndRefreshToken = this.umsProperties.getDelimiterOfTokenAndRefreshToken();
        String jwtRefreshTokenFromSession = JwtContext.getJwtRefreshTokenFromSession();
        if (StringUtils.hasText((String)jwtRefreshTokenFromSession)) {
            tkValue = tkValue.concat(delimiterOfTokenAndRefreshToken).concat(jwtRefreshTokenFromSession);
        } else {
            String refreshTokenFromHeader = response.getHeader(this.refreshTokenHeaderName);
            if (StringUtils.hasText((String)refreshTokenFromHeader)) {
                tkValue = tkValue.concat(delimiterOfTokenAndRefreshToken).concat(refreshTokenFromHeader);
            }
        }
        if ((this.domain + "/").equals(targetUrl) || this.domain.equals(targetUrl)) {
            targetUrl = this.domain + request.getContextPath();
        }
        tkValue = tkValue.concat(delimiterOfTokenAndRefreshToken).concat(targetUrl);
        try (RedisConnection connection = this.getConnection();){
            connection.setEx((this.umsProperties.getTempOauth2TokenPrefix() + uuid).getBytes(StandardCharsets.UTF_8), this.umsProperties.getTempOauth2TokenTimeout().getSeconds(), tkValue.getBytes(StandardCharsets.UTF_8));
        }
        this.clearAuthenticationAttributes(request);
        StringBuilder url = new StringBuilder(request.getContextPath() + this.umsProperties.getAutoGetTokenUri());
        url.append("?").append(this.umsProperties.getOauth2TokenParamName()).append("=").append(uuid).append("&username=").append(jwtAuthentication.getName()).append("&id=").append(jwtAuthentication.getName());
        response.sendRedirect(url.toString());
    }

    private String getJsonTargetUrl(String targetUrl, HttpServletRequest request) {
        String contextPath;
        if (!UrlUtils.isAbsoluteUrl((String)targetUrl) && !targetUrl.startsWith(contextPath = request.getContextPath())) {
            targetUrl = contextPath + targetUrl;
        }
        return targetUrl;
    }

    private boolean isIgnoreUrl(String targetUrl, HttpServletRequest request) {
        String url = RequestUtil.getRequestUri((String)targetUrl, (HttpServletRequest)request);
        return this.ignoreUrls.stream().anyMatch(url::startsWith);
    }

    @NonNull
    private RedisConnection getConnection() {
        return this.redisConnectionFactory.getConnection();
    }
}

