/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.config;

import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.core.auth.config.SecurityAutoConfiguration;
import top.dcenter.ums.security.core.auth.properties.ClientProperties;
import top.dcenter.ums.security.core.auth.properties.SmsCodeLoginAuthenticationProperties;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.jwt.config.JwtAutoConfiguration;
import top.dcenter.ums.security.jwt.resolver.UmsBearerTokenResolver;

@Configuration
@AutoConfigureAfter(value={Auth2AutoConfiguration.class, SecurityAutoConfiguration.class, JwtAutoConfiguration.class})
public class JwtBearerTokenResolverAutoConfiguration
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(JwtBearerTokenResolverAutoConfiguration.class);
    private ApplicationContext applicationContext;
    private final Set<String> ignoreUrls = new HashSet<String>();

    public JwtBearerTokenResolverAutoConfiguration(ClientProperties clientProperties, Auth2Properties auth2Properties, SmsCodeLoginAuthenticationProperties smsCodeLoginAuthenticationProperties) {
        this.ignoreUrls.add(clientProperties.getLoginPage());
        this.ignoreUrls.add(clientProperties.getLoginProcessingUrl());
        if (clientProperties.getOpenAuthenticationRedirect().booleanValue()) {
            this.ignoreUrls.add(clientProperties.getLoginUnAuthenticationRoutingUrl());
        }
        if (smsCodeLoginAuthenticationProperties.getSmsCodeLoginIsOpen().booleanValue()) {
            this.ignoreUrls.add(smsCodeLoginAuthenticationProperties.getLoginProcessingUrlMobile());
        }
        if (auth2Properties.getEnabled().booleanValue()) {
            this.ignoreUrls.add(auth2Properties.getAuthLoginUrlPrefix() + "/*");
            this.ignoreUrls.add(auth2Properties.getRedirectUrlPrefix() + "/*");
        }
    }

    public void afterPropertiesSet() {
        try {
            UmsBearerTokenResolver umsBearerTokenResolver = (UmsBearerTokenResolver)this.applicationContext.getBean(UmsBearerTokenResolver.class);
            umsBearerTokenResolver.addIgnoreUrls(this.ignoreUrls);
        }
        catch (Exception e) {
            log.warn("JWT \u529f\u80fd\u672a\u5f00\u542f...");
        }
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

