/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import demo.validate.code.slider.SliderCode;
import demo.validate.code.slider.SliderCodeFactory;
import demo.validate.code.slider.SliderCodeUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

@Component
public class SimpleSliderCodeFactory
implements SliderCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleSliderCodeFactory.class);
    private static final int CUT_WIDTH = 50;
    private static final int CUT_HEIGHT = 50;
    private static final int SLIDER_IMG_SLIDER_IMG_EXPIRE_IN = 180;
    private static final String RELATIVE_PATH = "static/image/validate/targets";

    @Override
    public SliderCode getSliderCode() {
        try {
            SliderCode sliderCode = SliderCodeUtil.getSliderCodeImage(this.getRandomAbsPath(), 50, 50, 180);
            sliderCode.setToken(ValidateCodeUtil.getUUID());
            sliderCode.setExpireTime(180);
            return sliderCode;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
        }
    }

    private String getRandomAbsPath() {
        try {
            String[] fileNames;
            File dirFile = ResourceUtils.getFile((String)"classpath:static/image/validate/targets");
            if (dirFile.isDirectory() && (fileNames = dirFile.list()) != null) {
                int r = ThreadLocalRandom.current().nextInt(fileNames.length);
                return String.format("%s%s%s", dirFile.getPath(), "/", fileNames[r]);
            }
        }
        catch (FileNotFoundException e) {
            log.info(String.format("\u751f\u4ea7 slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: %s", RELATIVE_PATH), (Throwable)e);
        }
        log.info("\u751f\u4ea7 slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: {}", (Object)RELATIVE_PATH);
        throw new RuntimeException("\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: static/image/validate/targets");
    }
}

