/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import demo.validate.code.slider.SliderCode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Base64Utils;

public class SliderCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(SliderCodeUtil.class);
    private static final int ORI_WIDTH = 350;
    private static final int ORI_HEIGHT = 213;
    private static final int CUT_WIDTH = 50;
    private static final int CUT_HEIGHT = 50;
    private static final int CIRCLE_R = 5;
    private static final int RECTANGLE_PADDING = 8;
    private static final int SLIDER_IMG_OUT_PADDING = 1;

    public static SliderCode getSliderCodeImage(String filePath, int cutWidth, int cutHeight, int expireIn) throws IOException {
        BufferedImage srcImage = ImageIO.read(new File(filePath));
        int locationX = cutWidth + new Random().nextInt(srcImage.getWidth() - cutWidth * 3);
        int locationY = cutHeight + new Random().nextInt(srcImage.getHeight() - cutHeight) / 2;
        BufferedImage markImage = new BufferedImage(cutWidth, cutHeight, 6);
        int[][] data = SliderCodeUtil.getBlockData(cutWidth, cutHeight);
        SliderCodeUtil.cutImgByTemplate(srcImage, markImage, data, locationX, locationY, cutWidth, cutHeight);
        return new SliderCode(null, expireIn, null, SliderCodeUtil.getImageBASE64(markImage), SliderCodeUtil.getImageBASE64(srcImage), locationX, locationY, srcImage.getWidth(), srcImage.getHeight());
    }

    private static int[][] getBlockData(int cutWidth, int cutHeight) {
        int j;
        int i;
        int[][] data = new int[cutWidth][cutHeight];
        Random random = new Random();
        double x1 = 8.0 + (double)(cutWidth - 16) / 2.0 - 5.0 + (double)random.nextInt(10);
        double y1_top = 8 - random.nextInt(3);
        double y1_bottom = cutHeight - 8 + random.nextInt(3);
        double y1 = random.nextInt(2) == 1 ? y1_top : y1_bottom;
        double x2_right = cutWidth - 8 - 5 + random.nextInt(6);
        double x2_left = 11 - random.nextInt(6);
        double x2 = random.nextInt(2) == 1 ? x2_right : x2_left;
        double y2 = 8.0 + (double)(cutHeight - 16) / 2.0 - 4.0 + (double)random.nextInt(10);
        double po = Math.pow(5.0, 2.0);
        for (i = 0; i < cutWidth; ++i) {
            for (j = 0; j < cutHeight; ++j) {
                boolean fill;
                if (i >= 8 && i < cutWidth - 8 && j >= 8 && j < cutHeight - 8) {
                    data[i][j] = 1;
                    fill = true;
                } else {
                    data[i][j] = 0;
                    fill = false;
                }
                double d3 = Math.pow((double)i - x1, 2.0) + Math.pow((double)j - y1, 2.0);
                if (d3 < po) {
                    data[i][j] = 1;
                } else if (!fill) {
                    data[i][j] = 0;
                }
                double d4 = Math.pow((double)i - x2, 2.0) + Math.pow((double)j - y2, 2.0);
                if (!(d4 < po)) continue;
                data[i][j] = 0;
            }
        }
        for (i = 0; i < cutWidth; ++i) {
            for (j = 0; j < cutHeight; ++j) {
                for (int k = 1; k <= 1; ++k) {
                    if (i >= 8 - k && i < 8 && (j >= 8 - k && j < 8 || j >= cutHeight - 8 - k && j < cutHeight - 8 + 1)) {
                        data[i][j] = 2;
                    }
                    if (i < cutWidth - 8 + k - 1 || i >= cutWidth - 8 + 1) continue;
                    for (int n = 1; n <= 1; ++n) {
                        if ((j < 8 - n || j >= 8) && (j < cutHeight - 8 - n || j > cutHeight - 8)) continue;
                        data[i][j] = 2;
                    }
                }
                if (data[i][j] == 1 && j - 1 > 0 && data[i][j - 1] == 0) {
                    data[i][j - 1] = 2;
                }
                if (data[i][j] == 1 && j + 1 > 0 && j + 1 < cutHeight && data[i][j + 1] == 0) {
                    data[i][j + 1] = 2;
                }
                if (data[i][j] == 1 && i - 1 > 0 && data[i - 1][j] == 0) {
                    data[i - 1][j] = 2;
                }
                if (data[i][j] != 1 || i + 1 <= 0 || i + 1 >= cutWidth || data[i + 1][j] != 0) continue;
                data[i + 1][j] = 2;
            }
        }
        return data;
    }

    private static void cutImgByTemplate(BufferedImage oriImage, BufferedImage targetImage, int[][] blockImage, int x, int y, int cutWidth, int cutHeight) {
        for (int i = 0; i < cutWidth; ++i) {
            for (int j = 0; j < cutHeight; ++j) {
                int _x = x + i;
                int _y = y + j;
                int rgbFlg = blockImage[i][j];
                int rgb_ori = oriImage.getRGB(_x, _y);
                if (rgbFlg == 1) {
                    targetImage.setRGB(i, j, rgb_ori);
                    oriImage.setRGB(_x, _y, Color.LIGHT_GRAY.getRGB());
                    continue;
                }
                if (rgbFlg == 2) {
                    targetImage.setRGB(i, j, Color.WHITE.getRGB());
                    oriImage.setRGB(_x, _y, Color.GRAY.getRGB());
                    continue;
                }
                if (rgbFlg != 0) continue;
                targetImage.setRGB(i, j, rgb_ori & 0xFFFFFF);
            }
        }
    }

    public static BufferedImage getRandomImage(String path) throws IOException {
        File files = new File(path);
        File[] fileList = files.listFiles();
        ArrayList<String> fileNameList = new ArrayList<String>();
        if (fileList != null && fileList.length != 0) {
            for (File tempFile : fileList) {
                if (!tempFile.isFile() || !tempFile.getName().endsWith(".jpg")) continue;
                fileNameList.add(tempFile.getAbsolutePath().trim());
            }
        }
        Random random = new Random();
        File imageFile = new File((String)fileNameList.get(random.nextInt(fileNameList.size())));
        return ImageIO.read(imageFile);
    }

    public static void writeImg(BufferedImage image, String file) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", baos);
        byte[] imageData = baos.toByteArray();
        FileOutputStream out = new FileOutputStream(new File(file));
        out.write(imageData);
        out.close();
    }

    public static String getImageBASE64(BufferedImage image) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "png", out);
        byte[] bytes = out.toByteArray();
        return Base64Utils.encodeToString((byte[])bytes);
    }

    public static BufferedImage base64StringToImage(String base64String) {
        try {
            byte[] bytes = Base64Utils.decodeFromString((String)base64String);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            return ImageIO.read(byteArrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

