/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import com.fasterxml.jackson.databind.ObjectMapper;
import demo.validate.code.slider.SliderCode;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.util.AuthenticationUtil;

@Component
public class SliderCoderProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SliderCoderProcessor.class);
    private final ObjectMapper objectMapper;

    public SliderCoderProcessor(ValidateCodeGeneratorHolder validateCodeGeneratorHolder, ObjectMapper objectMapper) {
        super(validateCodeGeneratorHolder);
        this.objectMapper = objectMapper;
    }

    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof SliderCode)) {
                return false;
            }
            SliderCode sliderCode = (SliderCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            String resultJson = this.objectMapper.writeValueAsString((Object)sliderCode);
            AuthenticationUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)resultJson);
            log.info("Demo ========>: sliderCode = {}", (Object)resultJson);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.SLIDER;
    }
}

