/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import demo.validate.code.slider.SliderCode;
import demo.validate.code.slider.SliderCodeFactory;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

@Component
public class SliderValidateCodeGenerator
implements ValidateCodeGenerator<SliderCode> {
    private static final Logger log = LoggerFactory.getLogger(SliderValidateCodeGenerator.class);
    public static final String TOKEN_PARAM_NAME = "token";
    public static final String X_PARAM_NAME = "x";
    public static final String Y_PARAM_NAME = "y";
    private final SliderCodeFactory sliderCodeFactory;
    private final ValidateCodeProperties validateCodeProperties;

    public SliderValidateCodeGenerator(SliderCodeFactory sliderCodeFactory, ValidateCodeProperties validateCodeProperties) {
        this.sliderCodeFactory = sliderCodeFactory;
        this.validateCodeProperties = validateCodeProperties;
    }

    public SliderCode generate(ServletRequest request) {
        SliderCode sliderCode = this.sliderCodeFactory.getSliderCode();
        log.info("Demo =====>: {} = {}", (Object)this.getValidateCodeType(), (Object)sliderCode);
        return sliderCode;
    }

    public String getValidateCodeType() {
        return ValidateCodeType.SLIDER.name().toLowerCase();
    }

    public String getRequestParamValidateCodeName() {
        return this.validateCodeProperties.getSlider().getRequestParamName();
    }

    public void validate(ServletWebRequest request) throws ValidateCodeException {
        boolean verify;
        HttpServletRequest req = request.getRequest();
        String sessionKey = ValidateCodeType.SLIDER.getSessionKey();
        HttpSession session = req.getSession();
        SliderCode sliderCodeInSession = (SliderCode)((Object)session.getAttribute(sessionKey));
        if (sliderCodeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), request.getSessionId());
        }
        if (sliderCodeInSession.getSecondCheck().booleanValue()) {
            this.defaultValidate(request);
            return;
        }
        String token = request.getParameter(TOKEN_PARAM_NAME);
        String x = request.getParameter(X_PARAM_NAME);
        String y = request.getParameter(Y_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((String)token), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, TOKEN_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((String)x), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, X_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((String)y), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, Y_PARAM_NAME);
        token = token.trim();
        Integer locationX = Integer.parseInt(x);
        Integer locationY = Integer.parseInt(y);
        this.checkParam(sessionKey, session, req, sliderCodeInSession.isExpired(), ErrorCodeEnum.VALIDATE_CODE_EXPIRED, token);
        boolean bl = verify = sliderCodeInSession.getLocationY().equals(locationY) && Math.abs(sliderCodeInSession.getLocationX() - locationX) < 2;
        if (!verify) {
            if (!sliderCodeInSession.getReuse().booleanValue()) {
                session.removeAttribute(sessionKey);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_FAILURE, req.getRemoteAddr(), token);
        }
        sliderCodeInSession.setSecondCheck(true);
        sliderCodeInSession.setCode(sliderCodeInSession.getToken());
        sliderCodeInSession.setReuse(false);
        session.setAttribute(sessionKey, (Object)sliderCodeInSession);
    }

    private void checkParam(String sessionKey, HttpSession session, HttpServletRequest req, boolean condition, ErrorCodeEnum errorCodeEnum, String errorData) throws ValidateCodeException {
        if (condition) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(errorCodeEnum, req.getRemoteAddr(), errorData);
        }
    }
}

