/*
 * Decompiled with CFR 0.152.
 */
package demo.service;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserCache;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.service.AbstractUserDetailsService;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.RegisterUserFailureException;
import top.dcenter.ums.security.core.exception.UserNotExistException;

@Service
public class UserDetailsService
extends AbstractUserDetailsService {
    private static final Logger log = LoggerFactory.getLogger(UserDetailsService.class);
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    private final ObjectMapper objectMapper;
    private final JdbcTemplate jdbcTemplate;
    @Autowired(required=false)
    private UserCache userCache;
    @Autowired
    private PasswordEncoder passwordEncoder;

    public UserDetailsService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            UserDetails userDetails;
            if (this.userCache != null && (userDetails = this.userCache.getUserFromCache(username)) != null) {
                return userDetails;
            }
            log.info("Demo ======>: \u767b\u5f55\u7528\u6237\u540d\uff1a{}, \u767b\u5f55\u6210\u529f", (Object)username);
            return new User(username, this.passwordEncoder.encode((CharSequence)"admin"), true, true, true, true, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"admin, ROLE_USER"));
        }
        catch (Exception e) {
            String msg = String.format("Demo ======>: \u767b\u5f55\u7528\u6237\u540d\uff1a%s, \u767b\u5f55\u5931\u8d25: %s", username, e.getMessage());
            log.error(msg, (Throwable)e);
            throw new UserNotExistException(ErrorCodeEnum.QUERY_USER_INFO_ERROR, (Throwable)e, username);
        }
    }

    public UserDetails registerUser(String mobile) throws RegisterUserFailureException {
        if (mobile == null) {
            throw new RegisterUserFailureException(ErrorCodeEnum.MOBILE_NOT_EMPTY, null);
        }
        log.info("Demo ======>: \u624b\u673a\u77ed\u4fe1\u767b\u5f55\u7528\u6237 {}\uff1a\u6ce8\u518c\u6210\u529f", (Object)mobile);
        User user = new User(mobile, this.passwordEncoder.encode((CharSequence)"admin"), true, true, true, true, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"admin, ROLE_USER"));
        if (this.userCache != null) {
            this.userCache.putUserInCache((UserDetails)user);
        }
        return user;
    }

    public UserDetails registerUser(ServletWebRequest request) throws RegisterUserFailureException {
        String username = this.getValueOfRequest(request, PARAM_USERNAME, ErrorCodeEnum.USERNAME_NOT_EMPTY);
        String password = this.getValueOfRequest(request, PARAM_PASSWORD, ErrorCodeEnum.PASSWORD_NOT_EMPTY);
        String encodedPassword = this.passwordEncoder.encode((CharSequence)password);
        log.info("Demo ======>: \u7528\u6237\u540d\uff1a{}, \u6ce8\u518c\u6210\u529f", (Object)username);
        User user = new User(username, encodedPassword, true, true, true, true, (Collection)AuthorityUtils.commaSeparatedStringToAuthorityList((String)"admin, ROLE_USER"));
        if (this.userCache != null) {
            this.userCache.putUserInCache((UserDetails)user);
        }
        return user;
    }

    private String getValueOfRequest(ServletWebRequest request, String paramName, ErrorCodeEnum usernameNotEmpty) throws RegisterUserFailureException {
        String result = request.getParameter(paramName);
        if (result == null) {
            throw new RegisterUserFailureException(usernameNotEmpty, request.getSessionId());
        }
        return result;
    }
}

