/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import demo.validate.code.slider.SliderCode;
import demo.validate.code.slider.SliderCodeFactory;
import demo.validate.code.slider.SliderCodeUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

@Component(value="demoSimpleSliderCodeFactory")
public class SimpleSliderCodeFactory
implements SliderCodeFactory {
    private static final Logger log = LoggerFactory.getLogger(SimpleSliderCodeFactory.class);
    private static final int CIRCLE_R = 5;
    private static final int RECTANGLE_PADDING = 8;
    private static final int SLIDER_IMG_OUT_PADDING = 1;
    private static final int CUT_WIDTH = 50;
    private static final int CUT_HEIGHT = 50;
    private static final int SLIDER_IMG_SLIDER_IMG_EXPIRE_IN = 180;
    private static final String RELATIVE_PATH = "static/image/validate/targets";

    @Override
    public SliderCode getSliderCode() {
        try {
            SliderCode sliderCode = SliderCodeUtil.getSliderCodeImage(this.getRandomAbsPath(RELATIVE_PATH), 50, 50, 5, 8, 1, 180);
            sliderCode.setToken(ValidateCodeUtil.getUUID());
            return sliderCode;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ValidateCodeException(ErrorCodeEnum.GET_VALIDATE_CODE_FAILURE, null, null);
        }
    }

    private String getRandomAbsPath(String originalImageDirectory) {
        try {
            String[] fileNames;
            File dirFile = ResourceUtils.getFile((String)("classpath:" + originalImageDirectory));
            if (dirFile.isDirectory() && (fileNames = dirFile.list()) != null) {
                int r = ThreadLocalRandom.current().nextInt(fileNames.length);
                return String.format("%s%s%s", dirFile.getPath(), "/", fileNames[r]);
            }
        }
        catch (FileNotFoundException e) {
            log.info(String.format("\u4ea7\u751f slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: %s", originalImageDirectory), (Throwable)e);
        }
        log.info("\u4ea7\u751f slider \u9a8c\u8bc1\u7801\u56fe\u7247\u65f6\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: {}", (Object)originalImageDirectory);
        throw new RuntimeException("\u627e\u4e0d\u5230\u56fe\u7247\u6e90, \u56fe\u7247\u6e90\u76f8\u5bf9\u8def\u5f84: " + originalImageDirectory);
    }
}

