/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import com.fasterxml.jackson.databind.ObjectMapper;
import demo.validate.code.slider.SliderCode;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.ServletWebRequest;
import top.dcenter.ums.security.core.api.validate.code.AbstractValidateCodeProcessor;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCode;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeGeneratorHolder;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.enums.ErrorCodeEnum;
import top.dcenter.ums.security.core.exception.ValidateCodeException;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;
import top.dcenter.ums.security.core.util.AuthenticationUtil;
import top.dcenter.ums.security.core.util.ValidateCodeUtil;

@Component(value="demoSliderCoderProcessor")
public class SliderCoderProcessor
extends AbstractValidateCodeProcessor {
    private static final Logger log = LoggerFactory.getLogger(SliderCoderProcessor.class);
    public static final String TOKEN_REQUEST_PARAM_NAME = "sliderToken";
    public static final String X_REQUEST_PARAM_NAME = "x";
    public static final String Y_REQUEST_PARAM_NAME = "y";
    private final ObjectMapper objectMapper;
    @Autowired
    private ValidateCodeProperties validateCodeProperties;

    public SliderCoderProcessor(ValidateCodeGeneratorHolder validateCodeGeneratorHolder, ObjectMapper objectMapper) {
        super(validateCodeGeneratorHolder);
        this.objectMapper = objectMapper;
    }

    public boolean sent(ServletWebRequest request, ValidateCode validateCode) {
        try {
            if (!(validateCode instanceof SliderCode)) {
                return false;
            }
            SliderCode sliderCode = (SliderCode)validateCode;
            HttpServletResponse response = request.getResponse();
            if (response == null) {
                return false;
            }
            String resultJson = this.objectMapper.writeValueAsString((Object)sliderCode);
            AuthenticationUtil.responseWithJson((HttpServletResponse)response, (int)HttpStatus.OK.value(), (String)resultJson);
            log.info("Demo ========>: sliderCode = {}", (Object)resultJson);
            return true;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public ValidateCodeType getValidateCodeType() {
        return ValidateCodeType.CUSTOMIZE;
    }

    public void validate(ServletWebRequest request) throws ValidateCodeException {
        boolean verify;
        HttpServletRequest req = request.getRequest();
        ValidateCodeType sliderType = ValidateCodeType.CUSTOMIZE;
        String sessionKey = sliderType.getSessionKey();
        HttpSession session = req.getSession();
        SliderCode sliderCodeInSession = (SliderCode)((Object)session.getAttribute(sessionKey));
        if (sliderCodeInSession == null) {
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_EXPIRED, req.getRemoteAddr(), request.getSessionId());
        }
        if (sliderCodeInSession.getSecondCheck().booleanValue()) {
            this.defaultValidate(request, TOKEN_REQUEST_PARAM_NAME);
            return;
        }
        String token = request.getParameter(TOKEN_REQUEST_PARAM_NAME);
        String x = request.getParameter(X_REQUEST_PARAM_NAME);
        String y = request.getParameter(Y_REQUEST_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)token), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, TOKEN_REQUEST_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)x), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, X_REQUEST_PARAM_NAME);
        this.checkParam(sessionKey, session, req, !StringUtils.isNotBlank((CharSequence)y), ErrorCodeEnum.VALIDATE_CODE_NOT_EMPTY, Y_REQUEST_PARAM_NAME);
        token = token.trim();
        Integer locationX = Integer.parseInt(x);
        Integer locationY = Integer.parseInt(y);
        this.checkParam(sessionKey, session, req, sliderCodeInSession.isExpired(), ErrorCodeEnum.VALIDATE_CODE_EXPIRED, token);
        boolean bl = verify = sliderCodeInSession.getLocationY().equals(locationY) && Math.abs(sliderCodeInSession.getLocationX() - locationX) < 2;
        if (!verify) {
            if (!sliderCodeInSession.getReuse().booleanValue()) {
                session.removeAttribute(sessionKey);
            }
            throw new ValidateCodeException(ErrorCodeEnum.VALIDATE_CODE_FAILURE, req.getRemoteAddr(), token);
        }
        sliderCodeInSession.setSecondCheck(true);
        sliderCodeInSession.setCode(ValidateCodeUtil.getUUID());
        sliderCodeInSession.setReuse(false);
        session.setAttribute(sessionKey, (Object)sliderCodeInSession);
    }

    private void checkParam(String sessionKey, HttpSession session, HttpServletRequest req, boolean condition, ErrorCodeEnum errorCodeEnum, String errorData) throws ValidateCodeException {
        if (condition) {
            session.removeAttribute(sessionKey);
            throw new ValidateCodeException(errorCodeEnum, req.getRemoteAddr(), errorData);
        }
    }
}

