/*
 * Decompiled with CFR 0.152.
 */
package demo.validate.code.slider;

import demo.validate.code.slider.SliderCode;
import demo.validate.code.slider.SliderCodeFactory;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.dcenter.ums.security.core.api.validate.code.ValidateCodeGenerator;
import top.dcenter.ums.security.core.auth.validate.codes.ValidateCodeType;
import top.dcenter.ums.security.core.properties.ValidateCodeProperties;

@Component(value="demoSliderValidateCodeGenerator")
public class SliderValidateCodeGenerator
implements ValidateCodeGenerator<SliderCode> {
    private static final Logger log = LoggerFactory.getLogger(SliderValidateCodeGenerator.class);
    private final SliderCodeFactory sliderCodeFactory;
    private final ValidateCodeProperties validateCodeProperties;

    public SliderValidateCodeGenerator(SliderCodeFactory sliderCodeFactory, ValidateCodeProperties validateCodeProperties) {
        this.sliderCodeFactory = sliderCodeFactory;
        this.validateCodeProperties = validateCodeProperties;
    }

    public SliderCode generate(ServletRequest request) {
        SliderCode sliderCode = this.sliderCodeFactory.getSliderCode();
        log.info("Demo =====>: {} = {}", (Object)this.getValidateCodeType(), (Object)sliderCode);
        return sliderCode;
    }

    public String getValidateCodeType() {
        return ValidateCodeType.CUSTOMIZE.name().toLowerCase();
    }

    public String getRequestParamValidateCodeName() {
        return this.validateCodeProperties.getCustomize().getRequestParamName();
    }
}

