/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.support.httpclient;

import com.xkcoding.http.config.HttpConfig;
import com.xkcoding.http.constants.Constants;
import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.support.AbstractHttp;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import com.xkcoding.http.util.StringUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientImpl
extends AbstractHttp {
    private final CloseableHttpClient httpClient;

    public HttpClientImpl() {
        this(HttpClients.createDefault(), new HttpConfig());
    }

    public HttpClientImpl(HttpConfig httpConfig) {
        this(HttpClients.createDefault(), httpConfig);
    }

    public HttpClientImpl(CloseableHttpClient httpClient, HttpConfig httpConfig) {
        super(httpConfig);
        this.httpClient = httpClient;
    }

    private String exec(HttpRequestBase request) {
        String string;
        block11: {
            this.addHeader(request);
            RequestConfig.Builder configBuilder = RequestConfig.custom().setConnectTimeout(this.httpConfig.getTimeout()).setSocketTimeout(this.httpConfig.getTimeout()).setConnectionRequestTimeout(this.httpConfig.getTimeout());
            if (null != this.httpConfig.getProxy()) {
                Proxy proxy = this.httpConfig.getProxy();
                InetSocketAddress address = (InetSocketAddress)proxy.address();
                HttpHost host = new HttpHost(address.getHostName(), address.getPort(), proxy.type().name().toLowerCase());
                configBuilder.setProxy(host);
            }
            request.setConfig(configBuilder.build());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            try {
                if (!this.isSuccess(response)) {
                    throw new SimpleHttpException("Unexpected code " + response);
                }
                StringBuffer body = new StringBuffer();
                if (response.getEntity() != null) {
                    body.append(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Constants.DEFAULT_ENCODING));
                }
                string = body.toString();
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SimpleHttpException(e);
                }
            }
            response.close();
        }
        return string;
    }

    private void addHeader(HttpRequestBase request) {
        String ua = "User-Agent";
        Header[] headers = request.getHeaders(ua);
        if (null == headers || headers.length == 0) {
            request.addHeader(ua, "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.142 Safari/537.36 simple-http");
        }
    }

    private boolean isSuccess(CloseableHttpResponse response) {
        if (response == null) {
            return false;
        }
        if (response.getStatusLine() == null) {
            return false;
        }
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
    }

    @Override
    public String get(String url) {
        return this.get(url, null, false);
    }

    @Override
    public String get(String url, Map<String, String> params, boolean encode) {
        return this.get(url, params, null, encode);
    }

    @Override
    public String get(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        String baseUrl = StringUtil.appendIfNotContain((String)url, "?", "&");
        url = baseUrl + MapUtil.parseMapToString(params, encode);
        HttpGet httpGet = new HttpGet((String)url);
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpGet)httpGet).addHeader(arg_0, arg_1));
        }
        return this.exec((HttpRequestBase)httpGet);
    }

    @Override
    public String post(String url) {
        HttpPost httpPost = new HttpPost(url);
        return this.exec((HttpRequestBase)httpPost);
    }

    @Override
    public String post(String url, String data) {
        return this.post(url, data, null);
    }

    @Override
    public String post(String url, String data, HttpHeader header) {
        HttpPost httpPost = new HttpPost(url);
        if (StringUtil.isNotEmpty(data)) {
            StringEntity entity = new StringEntity(data, Constants.DEFAULT_ENCODING);
            entity.setContentEncoding(Constants.DEFAULT_ENCODING.displayName());
            entity.setContentType("application/json; charset=utf-8");
            httpPost.setEntity((HttpEntity)entity);
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        }
        return this.exec((HttpRequestBase)httpPost);
    }

    @Override
    public String post(String url, Map<String, String> params, boolean encode) {
        return this.post(url, params, null, encode);
    }

    @Override
    public String post(String url, Map<String, String> params, HttpHeader header, boolean encode) {
        HttpPost httpPost = new HttpPost(url);
        if (MapUtil.isNotEmpty(params)) {
            ArrayList form = new ArrayList();
            MapUtil.forEach(params, (k, v) -> form.add(new BasicNameValuePair(k, v)));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(form, Constants.DEFAULT_ENCODING));
        }
        if (header != null) {
            MapUtil.forEach(header.getHeaders(), (arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
        }
        return this.exec((HttpRequestBase)httpPost);
    }
}

