/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.async.core;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class VisibleThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(VisibleThreadPoolTaskExecutor.class);
    private String poolName;
    private boolean printLog;
    private static final long serialVersionUID = -5872287707602314625L;

    private void printLog(String method) {
        if (!this.printLog) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = this.getThreadPoolExecutor();
        log.info("[async]\u573a\u666f\u542f\u52a8\u5668,\u7ebf\u7a0b\u6c60\uff1a{},{}, {}\u65b9\u6cd5\u6267\u884c,\u5f53\u524d\u4efb\u52a1\u6570\u91cf [{}], \u5b8c\u6210\u4efb\u52a1\u6570\u91cf [{}], \u6d3b\u8dc3\u7ebf\u7a0b\u6570 [{}], \u961f\u5217\u957f\u5ea6 [{}]", new Object[]{this.poolName, this.getThreadNamePrefix(), method, threadPoolExecutor.getTaskCount(), threadPoolExecutor.getCompletedTaskCount(), threadPoolExecutor.getActiveCount(), threadPoolExecutor.getQueue().size()});
    }

    public void execute(Runnable task) {
        this.printLog("execute");
        super.execute(task);
    }

    public Future<?> submit(Runnable task) {
        this.printLog("submit");
        return super.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        this.printLog("submit");
        return super.submit(task);
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        this.printLog("submitListenable");
        return super.submitListenable(task);
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        this.printLog("submitListenable");
        return super.submitListenable(task);
    }

    public VisibleThreadPoolTaskExecutor(String poolName, boolean printLog) {
        this.poolName = poolName;
        this.printLog = printLog;
    }
}

