/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.async.autoconfigure;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.json.JSONUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import top.dingwen.io.treasure.async.autoconfigure.AsyncProperties;
import top.dingwen.io.treasure.async.autoconfigure.PoolProperties;
import top.dingwen.io.treasure.async.core.ExecutorManagerImpl;
import top.dingwen.io.treasure.async.core.IExecutorManager;
import top.dingwen.io.treasure.async.core.VisibleThreadPoolTaskExecutor;
import top.dingwen.io.treasure.async.enums.PoolPolicy;
import top.dingwen.io.treasure.async.web.controller.AsyncIndexController;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={AsyncProperties.class})
@Lazy(value=false)
public class AsyncAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AsyncAutoConfiguration.class);
    @Resource
    private AsyncProperties asyncProperties;

    @PostConstruct
    public void init() {
        log.info("{}\n\n                             \n                             \n   __ _ ___ _   _ _ __   ___ \n  / _` / __| | | | '_ \\ / __|\n | (_| \\__ \\ |_| | | | | (__ \n  \\__,_|___/\\__, |_| |_|\\___|\n             __/ |           \n            |___/            ", (Object)"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668");
        log.info("{},\u8bfb\u53d6\u5230\u7684\u914d\u7f6e\u5982\u4e0b:\n{}", (Object)"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668", (Object)JSONUtil.toJsonPrettyStr((Object)this.asyncProperties));
        this.initExecutor();
    }

    @Bean
    @ConditionalOnProperty(name={"dingwen.treasure.async.defaultApiEnabled"}, havingValue="true")
    public AsyncIndexController asyncIndexController() {
        log.info("{},{},\u5df2\u7ecf\u6210\u529f\u52a0\u8f7d", (Object)"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668", (Object)"[AsyncIndexController]\u9ed8\u8ba4API");
        return new AsyncIndexController();
    }

    @Bean
    public IExecutorManager executorManager() {
        log.info("{},{},\u5df2\u7ecf\u6210\u529f\u52a0\u8f7d", (Object)"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668", (Object)"[IExecutorManager]\u6267\u884c\u5668\u7ba1\u7406\u7ec4\u4ef6");
        return new ExecutorManagerImpl();
    }

    private void initExecutor() {
        List<PoolProperties> pool = this.asyncProperties.getPool();
        if (CollUtil.isEmpty(pool)) {
            return;
        }
        pool.forEach(poolProperties -> {
            VisibleThreadPoolTaskExecutor taskExecutor = new VisibleThreadPoolTaskExecutor(poolProperties.getPoolBeanName(), this.asyncProperties.isLogPrint());
            taskExecutor.setCorePoolSize(poolProperties.getCore());
            taskExecutor.setMaxPoolSize(poolProperties.getMax());
            taskExecutor.setQueueCapacity(poolProperties.getQueueCapacity());
            taskExecutor.setKeepAliveSeconds(poolProperties.getKeepAliveTime());
            taskExecutor.setThreadNamePrefix(poolProperties.getPoolNamePrefix());
            taskExecutor.setRejectedExecutionHandler(this.adapterPoolPolicy(poolProperties.getPoolPolicy()));
            taskExecutor.initialize();
            SpringUtil.registerBean((String)poolProperties.getPoolBeanName(), (Object)((Object)taskExecutor));
            log.info("{},\u7ebf\u7a0b\u6c60\u521d\u59cb\u5316,\u7ebf\u7a0b\u6c60\u540d\u79f0:{},\u524d\u7f00:{},\u6838\u5fc3\u7ebf\u7a0b\u6570:{},\u6700\u5927\u7ebf\u7a0b\u6570:{},\u7f13\u5b58\u961f\u5217:{},\u5b58\u6d3b\u65f6\u95f4:{},\u62d2\u7edd\u7b56\u7565:{}", new Object[]{"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668", poolProperties.getPoolBeanName(), poolProperties.getPoolNamePrefix(), poolProperties.getCore(), poolProperties.getMax(), poolProperties.getQueueCapacity(), poolProperties.getKeepAliveTime(), poolProperties.getPoolPolicy()});
        });
        log.info("{},\u542f\u52a8\u6210\u529f\uff0c\u603b\u8ba1\u521d\u59cb\u5316\u7ebf\u7a0b\u6c60{}\u4e2a", (Object)"[async]\u5f02\u6b65\u5904\u7406\u573a\u666f\u542f\u52a8\u5668", (Object)pool.size());
    }

    private RejectedExecutionHandler adapterPoolPolicy(PoolPolicy poolPolicy) {
        if (Objects.isNull((Object)poolPolicy)) {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }
        switch (poolPolicy) {
            case ABORT_POLICY: {
                return new ThreadPoolExecutor.AbortPolicy();
            }
            case DISCARD_POLICY: {
                return new ThreadPoolExecutor.DiscardPolicy();
            }
            case DISCARD_OLDEST_POLICY: {
                return new ThreadPoolExecutor.DiscardOldestPolicy();
            }
        }
        return new ThreadPoolExecutor.CallerRunsPolicy();
    }
}

