/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.async.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.async.autoconfigure.AsyncProperties;
import top.dingwen.io.treasure.async.autoconfigure.PoolProperties;
import top.dingwen.io.treasure.async.core.IExecutorManager;
import top.dingwen.io.treasure.async.core.VisibleThreadPoolTaskExecutor;
import top.dingwen.io.treasure.async.web.convertor.ExecutorConvertor;
import top.dingwen.io.treasure.async.web.model.vo.ExecutorVO;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;

@Component
public class ExecutorManagerImpl
implements IExecutorManager {
    @Resource
    private AsyncProperties asyncProperties;

    @Override
    public List<ExecutorVO> getExecutorsInfo() {
        List<PoolProperties> pool = this.asyncProperties.getPool();
        if (CollUtil.isEmpty(pool)) {
            return Collections.emptyList();
        }
        List<ExecutorVO> executors = ExecutorConvertor.INSTANCE.convert(pool);
        for (ExecutorVO executor : executors) {
            VisibleThreadPoolTaskExecutor taskExecutor;
            String poolBeanName = executor.getPoolBeanName();
            if (StrUtil.isBlank((CharSequence)poolBeanName) || Objects.isNull((Object)(taskExecutor = (VisibleThreadPoolTaskExecutor)((Object)SpringUtils.getBean((String)poolBeanName, VisibleThreadPoolTaskExecutor.class))))) continue;
            executor.setActiveCount(taskExecutor.getActiveCount());
        }
        return executors;
    }
}

