package top.dingwen.io.treasure.async.autoconfigure;

import lombok.Getter;
import lombok.Setter;
import top.dingwen.io.treasure.async.enums.PoolPolicy;

/**
 * 线程池配置类
 *
 * @author dingwen
 * @since 2023/3/5 09:59
 */
@Getter
@Setter
public class PoolProperties {

    /**
     * 核心线程数
     */
    private Integer core;


    /**
     * 最大线程数
     */
    private Integer max;


    /**
     * 线程空闲时间
     */
    private Integer keepAliveTime;


    /**
     * 缓冲队列大小
     */
    private Integer queueCapacity;


    /**
     * 线程池前缀
     */
    private String poolNamePrefix;


    /**
     * 线程池对象名称
     */
    private String poolBeanName;

    /**
     * 线程池拒绝策略
     */
    private PoolPolicy poolPolicy;


    /**
     * 线程池名称
     */
    private String poolName;

}
