package top.dingwen.io.treasure.async.core;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

/**
 * 打印日志的线程池实现
 *
 * @author dingwen
 * @since 2023/5/30 13:32
 */
@Slf4j
@AllArgsConstructor
public class VisibleThreadPoolTaskExecutor extends ThreadPoolTaskExecutor {
    /**
     * 池名称
     */
    private String poolName;

    /**
     * 是否打印日志
     */
    private boolean printLog;

    /**
     * 打印日志
     *
     * @param method 方法
     */
    private void printLog(String method) {
        if (!printLog) {
            return;
        }
        ThreadPoolExecutor threadPoolExecutor = getThreadPoolExecutor();
        log.info("[async]场景启动器,线程池：{},{}, {}方法执行,当前任务数量 [{}], 完成任务数量 [{}], 活跃线程数 [{}], 队列长度 [{}]",
                this.poolName,
                this.getThreadNamePrefix(),
                method,
                threadPoolExecutor.getTaskCount(),
                threadPoolExecutor.getCompletedTaskCount(),
                threadPoolExecutor.getActiveCount(),
                threadPoolExecutor.getQueue().size());
    }


    @Override
    public void execute(Runnable task) {
        printLog("execute");
        super.execute(task);
    }

    @Override
    public Future<?> submit(Runnable task) {
        printLog("submit");
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        printLog("submit");
        return super.submit(task);
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        printLog("submitListenable");
        return super.submitListenable(task);
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        printLog("submitListenable");
        return super.submitListenable(task);
    }

    private static final long serialVersionUID = -5872287707602314625L;

}
