package top.dingwen.io.treasure.async.enums;

import top.dingwen.io.treasure.base.core.enums.IBaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 线程池拒绝策略
 *
 * @author dingwen
 * @since 2023/4/20 14:58
 */
@Getter
@AllArgsConstructor
public enum PoolPolicy implements IBaseEnum<String> {

    /**
     * AbortPolicy
     */
    ABORT_POLICY("AbortPolicy", "抛出一个类型为 RejectedExecutionException的RuntimeException"),

    /**
     * DiscardPolicy
     */
    DISCARD_POLICY("DiscardPolicy", "丢弃"),


    /**
     * DiscardOldestPolicy
     */
    DISCARD_OLDEST_POLICY("DiscardOldestPolicy", "如果线程池没被关闭且没有能力执行，则会丢弃任务队列中的头结点"),


    /**
     * CallerRunsPolicy
     */
    CALLER_RUNS_POLICY("CallerRunsPolicy", "当有新任务提交后，如果线程池没被关闭且没有能力执行，则把这个任务交于提交任务的线程执行，也就是谁提交任务，谁就负责执行任务");

    /**
     * 状态值
     */
    private final String code;

    /**
     * 状态描述
     */
    private final String desc;
}
