package top.dingwen.io.treasure.async.web.model.vo;

import lombok.*;
import top.dingwen.io.treasure.async.enums.PoolPolicy;

import java.io.Serializable;

/**
 * ExecutorVO : 执行器视图
 *
 * @author dingwen
 * @since 2024/6/27 14:12
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor(access = AccessLevel.PACKAGE)
public class ExecutorVO implements Serializable {
    private static final long serialVersionUID = 5534070681841424941L;
    /**
     * 核心线程数
     */
    private Integer core;


    /**
     * 最大线程数
     */
    private Integer max;


    /**
     * 线程空闲时间
     */
    private Integer keepAliveTime;


    /**
     * 缓冲队列大小
     */
    private Integer queueCapacity;


    /**
     * 线程池前缀
     */
    private String poolNamePrefix;


    /**
     * 线程池对象名称
     */
    private String poolBeanName;

    /**
     * 线程池拒绝策略
     */
    private PoolPolicy poolPolicy;


    /**
     * 线程池名称
     */
    private String poolName;

    /**
     * 当前活动线程的数量
     */
    private Integer activeCount;
}
