package top.dingwen.io.treasure.async.autoconfigure;

import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import java.util.Collections;
import java.util.List;

/**
 * 异步处理属性配置类
 *
 * @author dingwen
 * @since 2023/3/5 09:59
 */
@ConfigurationProperties(prefix = "dingwen.treasure.async")
@Getter
@Setter
public class AsyncProperties {

    /**
     * 线程池配置
     */
    private List<PoolProperties> pool = Collections.emptyList();

    /**
     * 是否打印日志
     */
    private boolean logPrint;

    /**
     * 是否开启默认API
     */
    private String defaultApiEnabled;

    /**
     * 定时线程池
     */
    private String delayScheduledPollEnabled;

    /**
     * 定时线程池核心线程数量
     */
    private Integer delayScheduledPollCoreSize = 10;
}
