package top.dingwen.io.treasure.async.core;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.async.autoconfigure.AsyncProperties;
import top.dingwen.io.treasure.async.autoconfigure.PoolProperties;
import top.dingwen.io.treasure.async.web.convertor.ExecutorConvertor;
import top.dingwen.io.treasure.async.web.model.vo.ExecutorVO;
import top.dingwen.io.treasure.base.util.spring.SpringUtils;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * ExecutorManagerImpl : 执行器管理组件
 *
 * @author dingwen
 * @since 2024/6/27 14:22
 */
@Component
public class ExecutorManagerImpl implements IExecutorManager {

    @Resource
    private AsyncProperties asyncProperties;

    @Override
    public List<ExecutorVO> getExecutorsInfo() {
        List<PoolProperties> pool = asyncProperties.getPool();
        if (CollUtil.isEmpty(pool)) {
            return Collections.emptyList();
        }
        List<ExecutorVO> executors = ExecutorConvertor.INSTANCE.convert(pool);
        for (ExecutorVO executor : executors) {
            String poolBeanName = executor.getPoolBeanName();
            if (StrUtil.isBlank(poolBeanName)) {
                continue;
            }
            VisibleThreadPoolTaskExecutor taskExecutor = SpringUtils.getBean(poolBeanName,
                    VisibleThreadPoolTaskExecutor.class);
            if (Objects.isNull(taskExecutor)) {
                continue;
            }
            executor.setActiveCount(taskExecutor.getActiveCount());
        }
        return executors;
    }
}
