package top.dingwen.io.treasure.async.web.controller;

import cn.hutool.core.convert.Convert;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;
import top.dingwen.io.treasure.async.autoconfigure.AsyncProperties;
import top.dingwen.io.treasure.async.constant.AsyncConstant;
import top.dingwen.io.treasure.async.core.IExecutorManager;
import top.dingwen.io.treasure.async.web.model.vo.ExecutorVO;
import top.dingwen.io.treasure.webplus.exception.NotSupportApiException;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.web.controller.BaseViewController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * AsyncIndexController : 异步场景API
 *
 * @author dingwen
 * @since 2024/6/27 14:32
 */
@RestController
@Slf4j
@RequestMapping("common/asyncs")
@Valid
public class AsyncIndexController implements BaseViewController {

    @Resource
    private IExecutorManager executorManager;

    @Resource
    private AsyncProperties asyncProperties;


    @Resource
    private ScheduledExecutorService defaultScheduledExecutorService;

    /**
     * 获取执行器消息
     *
     * @return {@link ResultVO }<{@link List }<{@link ExecutorVO }>>
     */
    @GetMapping("/ex-infos")
    public ResultVO<List<ExecutorVO>> getExecutorsInfo() {
        return success(executorManager.getExecutorsInfo());
    }

    /**
     * 定时任务线程池测试
     *
     * @param time   时间
     * @param timeUnit 时间单位
     * @return {@link ResultVO }<{@link String }>
     */
    @PutMapping("/test/scheduled")
    public ResultVO<String> testDefaultScheduled(@RequestParam Long time,
                                                @RequestParam TimeUnit timeUnit){
        if (!Convert.toBool(asyncProperties.getDelayScheduledPollEnabled(),false)) {
            throw new NotSupportApiException(AsyncConstant.AS_LOG_P_S,"定时任务线程池");
        }
        defaultScheduledExecutorService.schedule(
                () -> log.info("{},{},定时任务执行,时间[{}],单位[{}]",
                AsyncConstant.AS_LOG_P_S,
                AsyncConstant.AS_LOG_P_SCHEDULED,
                time,
                timeUnit
        ),time,timeUnit);
        return success();
    }
}
