/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.exception;

import javax.servlet.http.HttpServletRequest;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import top.dingwen.io.treasure.webplus.model.vo.ResultVO;
import top.dingwen.io.treasure.webplus.model.vo.ResultVOGenerator;

@RestControllerAdvice
public class MybatisExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MybatisExceptionHandler.class);

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResultVO<Void> handleDuplicateKeyException(DuplicateKeyException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        log.error("\u8bf7\u6c42\u5730\u5740'{}',\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8bb0\u5f55'{}'", (Object)requestURI, (Object)e.getMessage());
        return ResultVOGenerator.genFailureResultOnlyMessage((String)"\u6570\u636e\u5e93\u4e2d\u5df2\u5b58\u5728\u8be5\u8bb0\u5f55\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4");
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    public ResultVO<Void> handleCannotFindDataSourceException(MyBatisSystemException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String message = e.getMessage();
        log.error("\u8bf7\u6c42\u5730\u5740'{}', Mybatis\u7cfb\u7edf\u5f02\u5e38", (Object)requestURI, (Object)e);
        return ResultVOGenerator.genFailureResultOnlyMessage((String)message);
    }
}

