/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.interceptor;

import cn.hutool.core.convert.Convert;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class MybatisPlusSqlLogInterceptor
implements InnerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusSqlLogInterceptor.class);
    private static final String Q_S = "\u7f3a\u5931";
    private static final String R_X = "\\?";
    private static final String REG_B = "[\\s]+";
    private static final String C_SD = "'";

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) {
        MybatisPlusSqlLogInterceptor.logInfo(boundSql, ms, parameter);
    }

    public void beforeUpdate(Executor executor, MappedStatement ms, Object parameter) {
        BoundSql boundSql = ms.getBoundSql(parameter);
        MybatisPlusSqlLogInterceptor.logInfo(boundSql, ms, parameter);
    }

    private static void logInfo(BoundSql boundSql, MappedStatement ms, Object parameter) {
        try {
            String sqlId = ms.getId();
            log.info("{},{},Sql\u7f16\u53f7:[{}],\u53c2\u6570:\n{} ", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MybatisPlusSqlLogInterceptor]Sql\u6253\u5370\u62e6\u622a\u5668", sqlId, parameter});
            Configuration configuration = ms.getConfiguration();
            String sql = MybatisPlusSqlLogInterceptor.getSql(configuration, boundSql, sqlId);
            log.info("{},{},Sql\u7f16\u53f7:[{}],\u5b8c\u6574Sql:\n{} ", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MybatisPlusSqlLogInterceptor]Sql\u6253\u5370\u62e6\u622a\u5668", sqlId, sql});
        }
        catch (Exception e) {
            log.info("{},{},Sql\u7f16\u53f7:[{}],\u53d1\u751f\u4e86\u9519\u8bef,\u6d88\u606f[{}]", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[MybatisPlusSqlLogInterceptor]Sql\u6253\u5370\u62e6\u622a\u5668", ms.getId(), e.getLocalizedMessage(), e});
        }
    }

    public static String getSql(Configuration configuration, BoundSql boundSql, String sqlId) {
        return sqlId + ":\t" + MybatisPlusSqlLogInterceptor.showSql(configuration, boundSql);
    }

    public static String showSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        String sql = boundSql.getSql().replaceAll(REG_B, " ");
        if (!CollectionUtils.isEmpty((Collection)parameterMappings) && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = sql.replaceFirst(R_X, Matcher.quoteReplacement(MybatisPlusSqlLogInterceptor.getParameterValue(parameterObject)));
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Object obj;
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        obj = metaObject.getValue(propertyName);
                        sql = sql.replaceFirst(R_X, Matcher.quoteReplacement(MybatisPlusSqlLogInterceptor.getParameterValue(obj)));
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        obj = boundSql.getAdditionalParameter(propertyName);
                        sql = sql.replaceFirst(R_X, Matcher.quoteReplacement(MybatisPlusSqlLogInterceptor.getParameterValue(obj)));
                        continue;
                    }
                    sql = sql.replaceFirst(R_X, Q_S);
                }
            }
        }
        return sql;
    }

    private static String getParameterValue(Object obj) {
        if (obj instanceof String) {
            return C_SD + obj + C_SD;
        }
        if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            return C_SD + formatter.format(new Date()) + C_SD;
        }
        return Convert.toStr((Object)obj, (String)"");
    }
}

