/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.option;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.toolkit.SqlRunner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import top.dingwen.io.treasure.mybatisplus.model.OpParam;
import top.dingwen.io.treasure.mybatisplus.model.Option;
import top.dingwen.io.treasure.mybatisplus.support.option.IOptionService;

@Service
public class OptionServiceImpl
implements IOptionService {
    private static final Logger log = LoggerFactory.getLogger(OptionServiceImpl.class);
    private static final String LABEL = "label";
    private static final String VALUE = "value";
    private static final String KEY_CACHE_PREFIX = "OP_CACHE";
    private final Cache<String, List<Option>> OP_CACHE = CacheBuilder.newBuilder().maximumSize(2000L).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    private static final Integer LEVEL_ZERO = 0;
    private static final Integer LEVEL_ONE = 1;
    private static final Integer LEVEL_TWO = 2;
    private static final Integer LEVEL_THREE = 3;
    private static final Integer LEVEL_FOUR = 4;

    @Override
    public List<Option> getOptions(List<OpParam> opParams) {
        if (opParams.isEmpty()) {
            return Collections.emptyList();
        }
        String cacheKey = this.buildCacheKey(opParams);
        List cacheOps = (List)this.OP_CACHE.getIfPresent((Object)cacheKey);
        if (CollUtil.isNotEmpty((Collection)cacheOps)) {
            return cacheOps;
        }
        List<String> querySqls = this.buildQuerySql(opParams);
        if (CollUtil.isEmpty(querySqls)) {
            return Collections.emptyList();
        }
        List<Option> ops = this.queryOptions(querySqls.get(LEVEL_ZERO));
        if (querySqls.size() == LEVEL_ONE.intValue()) {
            return ops;
        }
        if (LEVEL_TWO <= querySqls.size()) {
            OpParam opParamTwo = opParams.get(LEVEL_ONE);
            String querySqlTwo = querySqls.get(LEVEL_ONE);
            this.setChildrenOps(ops, opParamTwo, querySqlTwo);
        }
        if (LEVEL_THREE <= querySqls.size()) {
            OpParam opParamThree = opParams.get(LEVEL_TWO);
            String querySqlThree = querySqls.get(LEVEL_TWO);
            for (Option op : ops) {
                this.setChildrenOps(op.getChildrenOps(), opParamThree, querySqlThree);
            }
        }
        if (LEVEL_FOUR <= querySqls.size()) {
            OpParam opParamFour = opParams.get(LEVEL_THREE);
            String querySqlFour = querySqls.get(LEVEL_THREE);
            for (Option op : ops) {
                for (Option childrenOp : op.getChildrenOps()) {
                    this.setChildrenOps(childrenOp.getChildrenOps(), opParamFour, querySqlFour);
                }
            }
        }
        this.OP_CACHE.put((Object)cacheKey, ops);
        return ops;
    }

    private List<String> buildQuerySql(List<OpParam> opParams) {
        String querySqlTemplate = "select {} as label, {} as value {} from {} {} where 1= 1 {} {}";
        return opParams.stream().map(param -> StrUtil.format((CharSequence)querySqlTemplate, (Object[])new Object[]{param.getLabelField(), param.getValueField(), param.getLeftJoinField(), param.getTableName(), param.getLeftJoinSql(), param.getWhereSql(), param.getOrderSql()}).replace("null", "")).collect(Collectors.toList());
    }

    private List<Option> queryOptions(String querySql) {
        log.info("[MybatisPlus\u6a21\u5757]\t[\u901a\u7528\u9009\u62e9\u67e5\u8be2\u7ec4\u4ef6]\uff0c\u6700\u7ec8\u67e5\u8be2SQL:{}", (Object)querySql);
        try {
            return SqlRunner.db().selectList(querySql, new Object[0]).stream().map(m -> Option.builder().label(m.get(LABEL)).value(m.get(VALUE)).build()).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException("[MybatisPlus\u6a21\u5757]\t[\u901a\u7528\u9009\u62e9\u67e5\u8be2\u7ec4\u4ef6]\uff0cSQL\u6267\u884c\u5f02\u5e38,\u8bf7\u68c0\u67e5:" + querySql);
        }
    }

    private void setChildrenOps(List<Option> tempOps, OpParam opParam, String querySql) {
        for (Option option : tempOps) {
            String parentWhereSql = CharSequenceUtil.format((CharSequence)"and {} = {}", (Object[])new Object[]{opParam.getParentField(), option.getValue()});
            String queryFullSql = querySql.concat(parentWhereSql);
            List<Option> childrenOps = this.queryOptions(queryFullSql);
            option.setChildrenOps(childrenOps);
        }
    }

    @Override
    public String buildCacheKey(List<OpParam> opParams) {
        StringBuilder key = new StringBuilder();
        opParams.stream().map(p -> KEY_CACHE_PREFIX.concat(":").concat(p.toString())).collect(Collectors.toList()).forEach(key::append);
        return key.toString();
    }

    @Override
    public void cleanCache() {
        this.OP_CACHE.cleanUp();
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.OP_CACHE.invalidate((Object)cacheKey);
    }
}

