/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.redundancy;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.dingwen.io.treasure.base.core.event.AbstractBaseListener;
import top.dingwen.io.treasure.mybatisplus.support.redundancy.IRedundancyMaintainService;
import top.dingwen.io.treasure.mybatisplus.support.redundancy.RedundancyMaintainEvent;

@Component
public class RedundancyMaintainListener
extends AbstractBaseListener<RedundancyMaintainEvent> {
    private static final Logger log = LoggerFactory.getLogger(RedundancyMaintainListener.class);

    protected void handler(RedundancyMaintainEvent event) {
        Map maintainServiceMap = SpringUtil.getBeansOfType(IRedundancyMaintainService.class);
        if (CollUtil.isEmpty((Map)maintainServiceMap)) {
            return;
        }
        for (Map.Entry entry : maintainServiceMap.entrySet()) {
            IRedundancyMaintainService maintainService = (IRedundancyMaintainService)entry.getValue();
            LambdaUpdateChainWrapper lambdaUpdate = maintainService.getLambdaUpdate();
            if (Objects.isNull(lambdaUpdate)) {
                log.warn("{},{},\u672a\u627e\u5230\u540d\u4e3a[{}]\u7684\u66f4\u65b0\u5668,\u53d6\u6d88\u6267\u884c", new Object[]{"[mybatis-plus]\u573a\u666f\u542f\u52a8\u5668", "[RedundancyMaintainListener]\u5197\u4f59\u6570\u636e\u7ef4\u62a4\u76d1\u542c\u5668", entry.getKey()});
                return;
            }
            if (!lambdaUpdate.getEntityClass().getName().equals(event.getUpdateFullClassName())) continue;
            maintainService.maintain(event.getConditionFieldFunc(), event.getConditionVal(), event.getUpdateFieldFunc(), event.getUpdateVal());
        }
    }
}

