/*
 * Decompiled with CFR 0.152.
 */
package top.dingwen.io.treasure.mybatisplus.support.tenant;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import top.dingwen.io.treasure.mybatisplus.constant.MybatisConstant;
import top.dingwen.io.treasure.mybatisplus.support.tenant.TenantIdContext;

@Component
public class MybatisPlusTenantDataSourceInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        Long tenantId = (Long)ObjectUtil.defaultIfNull(null, (Object)MybatisConstant.DEFAULT_TENANT_ID);
        String dataSourceName = (String)ObjectUtil.defaultIfBlank(null, (CharSequence)"default");
        String dataKey = this.buildDataKey(tenantId, dataSourceName);
        DynamicDataSourceContextHolder.push((String)dataKey);
        TenantIdContext.set(tenantId);
        return false;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        DynamicDataSourceContextHolder.clear();
        TenantIdContext.clear();
    }

    private String buildDataKey(Long tenantId, String dataSourceName) {
        return CharSequenceUtil.format((CharSequence)"{}:{}", (Object[])new Object[]{dataSourceName, tenantId});
    }
}

